/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class FluidStorageBlockEntity<F extends IFluidHandler>
extends BlockEntity
implements FluidStoragePacketUpdate {
    protected final FluidStorageMethods<F> fluidStorageMethods;
    protected final F fluidStorage;
    protected LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    protected final int baseTankCapacity;

    public FluidStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity) {
        super(type, blockPos, blockState);
        this.fluidStorageMethods = fluidStorageMethods;
        this.baseTankCapacity = baseTankCapacity;
        this.fluidStorage = this.initFluidStorage();
    }

    protected abstract F initFluidStorage();

    public void onLoad() {
        super.onLoad();
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.fluidStorageMethods.saveFluidStorage(this.fluidStorage, nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidStorageMethods.loadFluidStorage(this.fluidStorage, nbt);
    }

    protected final void syncFluidToPlayer(Player player) {
        this.fluidStorageMethods.syncFluidToPlayer(this.fluidStorage, player, this.f_58858_);
    }

    protected final void syncFluidToPlayers(int distance) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.fluidStorageMethods.syncFluidToPlayers(this.fluidStorage, this.f_58857_, this.f_58858_, distance);
        }
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorageMethods.getFluid(this.fluidStorage, tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorageMethods.getTankCapacity(this.fluidStorage, tank);
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorageMethods.setFluid(this.fluidStorage, tank, fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorageMethods.setTankCapacity(this.fluidStorage, tank, capacity);
    }
}

