/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.UpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.IComparatorModeHandler;
import me.jddev0.ep.machine.configuration.IRedstoneModeHandler;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableUpgradableInventoryEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage, I extends ItemStackHandler>
extends UpgradableInventoryEnergyStorageBlockEntity<E, I>
implements RedstoneModeUpdate,
IRedstoneModeHandler,
ComparatorModeUpdate,
IComparatorModeHandler {
    @NotNull
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    protected ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public ConfigurableUpgradableInventoryEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, int slotCount, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, slotCount, upgradeModifierSlots);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.m_128405_("configuration.comparator_mode", this.comparatorMode.ordinal());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.m_128451_("configuration.comparator_mode"));
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage(this.energyStorage);
        };
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }

    @Override
    @NotNull
    public @NotNull RedstoneMode @NotNull [] getAvailableRedstoneModes() {
        return RedstoneMode.values();
    }

    @Override
    @NotNull
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean setRedstoneMode(@NotNull RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.m_6596_();
        return true;
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.m_6596_();
    }

    @Override
    @NotNull
    public @NotNull ComparatorMode @NotNull [] getAvailableComparatorModes() {
        return new ComparatorMode[]{ComparatorMode.ENERGY, ComparatorMode.ITEM};
    }

    @Override
    @NotNull
    public ComparatorMode getComparatorMode() {
        return this.comparatorMode;
    }

    @Override
    public boolean setComparatorMode(@NotNull ComparatorMode comparatorMode) {
        if (comparatorMode == ComparatorMode.FLUID) {
            return false;
        }
        this.comparatorMode = comparatorMode;
        this.m_6596_();
        return true;
    }
}

