/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.WeatherControllerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherControllerBlockEntity
extends UpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    private static final int WEATHER_CHANGED_TICKS = ModConfigs.COMMON_WEATHER_CONTROLLER_CONTROL_DURATION.getValue();
    private int selectedWeatherType = -1;

    public WeatherControllerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.WEATHER_CONTROLLER_ENTITY.get(), blockPos, blockState, "weather_controller", ModConfigs.COMMON_WEATHER_CONTROLLER_CAPACITY.getValue(), ModConfigs.COMMON_WEATHER_CONTROLLER_TRANSFER_RATE.getValue(), UpgradeModuleModifier.DURATION);
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> WeatherControllerBlockEntity.this.selectedWeatherType;
                    case 1 -> {
                        if (WeatherControllerBlockEntity.this.hasEnoughEnergy()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        WeatherControllerBlockEntity.this.selectedWeatherType = value;
                        break;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * WeatherControllerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                WeatherControllerBlockEntity.this.m_6596_();
                WeatherControllerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new WeatherControllerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("selected_weather_type", (Tag)IntTag.m_128679_((int)this.selectedWeatherType));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.selectedWeatherType = nbt.m_128441_("selected_weather_type") ? nbt.m_128451_("selected_weather_type") : -1;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, WeatherControllerBlockEntity blockEntity) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!blockEntity.hasInfiniteWeatherChangedDuration() || blockEntity.selectedWeatherType == -1) {
            return;
        }
        double energyConsumptionPerTick = blockEntity.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
        if ((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() >= energyConsumptionPerTick) {
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy((int)((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick));
            if (level.m_46467_() % 100L == 0L) {
                int duration = blockEntity.getWeatherChangedDuration();
                switch (blockEntity.selectedWeatherType) {
                    case 0: {
                        serverLevel.m_8606_(duration, 0, false, false);
                        break;
                    }
                    case 1: {
                        serverLevel.m_8606_(0, duration, true, false);
                        break;
                    }
                    case 2: {
                        serverLevel.m_8606_(0, duration, true, true);
                    }
                }
            }
        } else {
            blockEntity.setSelectedWeatherType(-1);
        }
    }

    public void clearEnergy() {
        ((ReceiveOnlyEnergyStorage)this.energyStorage).setEnergy(0);
    }

    public boolean hasEnoughEnergy() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            double energyConsumptionPerTick = this.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
            return (double)((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() >= energyConsumptionPerTick;
        }
        return ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() >= ((ReceiveOnlyEnergyStorage)this.energyStorage).getCapacity();
    }

    public boolean hasInfiniteWeatherChangedDuration() {
        return this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION) == Double.POSITIVE_INFINITY;
    }

    public int getWeatherChangedDuration() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            return 300;
        }
        return (int)Math.max(1.0, (double)WEATHER_CHANGED_TICKS * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION));
    }

    public int getSelectedWeatherType() {
        return this.selectedWeatherType;
    }

    public void setSelectedWeatherType(int selectedWeatherType) {
        this.selectedWeatherType = selectedWeatherType;
        this.m_6596_();
    }

    @Override
    protected void updateUpgradeModules() {
        if (!this.hasInfiniteWeatherChangedDuration()) {
            this.selectedWeatherType = -1;
        }
        super.updateUpgradeModules();
    }
}

