/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.screen.TeleporterMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends MenuInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final boolean INTRA_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED.getValue();
    public static final boolean INTER_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> true));

    public TeleporterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.TELEPORTER_ENTITY.get(), blockPos, blockState, "teleporter", ModConfigs.COMMON_TELEPORTER_CAPACITY.getValue(), ModConfigs.COMMON_TELEPORTER_TRANSFER_RATE.getValue(), 1);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
                TeleporterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_150930_((Item)EPItems.TELEPORTER_MATRIX.get());
                }
                return super.isItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new TeleporterMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setChangedAndUpdateReadyState() {
        boolean powered;
        boolean oldPowered = this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)TeleporterBlock.POWERED) && (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)TeleporterBlock.POWERED) != false;
        ItemStack teleporterMatrixItemStack = this.itemHandler.getStackInSlot(0);
        boolean bl = powered = ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() == ((ReceiveOnlyEnergyStorage)this.energyStorage).getCapacity() && teleporterMatrixItemStack.m_150930_((Item)EPItems.TELEPORTER_MATRIX.get()) && TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        if (oldPowered ^ powered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TeleporterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        this.m_6596_();
    }

    public void onRedstoneTriggered() {
        ServerPlayer serverPlayer;
        Player player;
        block5: {
            block4: {
                Optional<Player> player2 = this.f_58857_.m_142425_(EntityTypeTest.m_156916_(Player.class), AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(this.f_58858_.m_123341_() - 2, this.f_58858_.m_123342_() - 2, this.f_58858_.m_123343_() - 2), (Vec3i)new Vec3i(this.f_58858_.m_123341_() + 2, this.f_58858_.m_123342_() + 2, this.f_58858_.m_123343_() + 2))), EntitySelector.f_20408_.and(entity -> entity.m_20238_(this.f_58858_.m_252807_()) <= 4.0)).stream().min(Comparator.comparing(entity -> entity.m_20238_(this.f_58858_.m_252807_())));
                if (player2.isEmpty()) {
                    return;
                }
                player = player2.get();
                if (!(player instanceof ServerPlayer)) break block4;
                serverPlayer = (ServerPlayer)player;
                player = this.f_58857_;
                if (player instanceof ServerLevel) break block5;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player;
        serverLevel.m_7654_().m_18689_(() -> this.teleportPlayer(serverPlayer));
    }

    public void teleportPlayer(ServerPlayer player) {
        LazyOptional energyStorageLazyOptional = this.getCapability(ForgeCapabilities.ENERGY, null);
        if (!energyStorageLazyOptional.isPresent()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        TeleporterBlockEntity.teleportPlayer(player, energyStorage, () -> ((ReceiveOnlyEnergyStorage)this.energyStorage).setEnergy(0), this.getStack(0), this.f_58857_, this.f_58858_);
    }

    public static void teleportPlayer(ServerPlayer player, IEnergyStorage energyStorage, Runnable clearEnergyCallback, ItemStack teleporterMatrixItemStack, Level level, @Nullable BlockPos pos) {
        ResourceLocation toDimensionId;
        if (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored()) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.not_enough_energy").m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!teleporterMatrixItemStack.m_150930_((Item)EPItems.TELEPORTER_MATRIX.get())) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.no_teleporter_matrix").m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!TeleporterMatrixItem.isLinked(teleporterMatrixItemStack)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_not_bound").m_130940_(ChatFormatting.RED)));
            return;
        }
        BlockPos toPos = TeleporterMatrixItem.getBlockPos(level, teleporterMatrixItemStack);
        if (toPos == null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_position").m_130940_(ChatFormatting.RED)));
            return;
        }
        Level toDimension = TeleporterMatrixItem.getDimension(level, teleporterMatrixItemStack);
        if (!(toDimension instanceof ServerLevel)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_dimension").m_130940_(ChatFormatting.RED)));
            return;
        }
        if (pos != null && pos.equals((Object)toPos) && level.m_46472_().equals((Object)toDimension.m_46472_())) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_self_position").m_130940_(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionId = level.m_46472_().m_135782_();
        boolean intraDimensional = fromDimensionId.equals((Object)(toDimensionId = toDimension.m_46472_().m_135782_()));
        if (intraDimensional && !INTRA_DIMENSIONAL_ENABLED) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.intra_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && !INTER_DIMENSIONAL_ENABLED) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.inter_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(toDimensionId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{toDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_BLACKLIST.contains(toDimensionId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to", (Object[])new Object[]{toDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionTypeId = level.m_220362_().m_135782_();
        ResourceLocation toDimensionTypeId = toDimension.m_220362_().m_135782_();
        if (DIMENSION_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{toDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to_type", (Object[])new Object[]{toDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        BlockEntity toBlockEntity = toDimension.m_7702_(toPos);
        if (!(toBlockEntity instanceof TeleporterBlockEntity)) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_no_teleporter").m_130940_(ChatFormatting.RED)));
            return;
        }
        clearEnergyCallback.run();
        Vec3 toPosCenter = toPos.m_252807_();
        player.m_264318_((ServerLevel)toDimension, toPosCenter.m_7096_(), (double)(toPos.m_123342_() + 1), toPosCenter.m_7094_(), new HashSet(), 0.0f, 0.0f);
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)SoundEvents.f_11852_), SoundSource.BLOCKS, toPosCenter.m_7096_(), (double)toPos.m_123342_(), toPosCenter.m_7094_(), 1.0f, 1.0f, toDimension.m_213780_().m_188505_()));
    }

    public int getSlotCount() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStack(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }
}

