/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.SolarPanelBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.SolarPanelMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends UpgradableEnergyStorageBlockEntity<ExtractOnlyEnergyStorage> {
    private final SolarPanelBlock.Tier tier;

    public static BlockEntityType<SolarPanelBlockEntity> getEntityTypeFromTier(SolarPanelBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case SolarPanelBlock.Tier.TIER_1 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_1.get();
            case SolarPanelBlock.Tier.TIER_2 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_2.get();
            case SolarPanelBlock.Tier.TIER_3 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_3.get();
            case SolarPanelBlock.Tier.TIER_4 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_4.get();
            case SolarPanelBlock.Tier.TIER_5 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_5.get();
            case SolarPanelBlock.Tier.TIER_6 -> (BlockEntityType)EPBlockEntities.SOLAR_PANEL_ENTITY_6.get();
        };
    }

    public SolarPanelBlockEntity(BlockPos blockPos, BlockState blockState, SolarPanelBlock.Tier tier) {
        super(SolarPanelBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState, tier.getResourceId(), tier.getCapacity(), tier.getMaxTransfer(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.MOON_LIGHT);
        this.tier = tier;
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                SolarPanelBlockEntity.this.m_6596_();
                SolarPanelBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new SolarPanelMenu(id, inventory, this, this.upgradeModuleInventory);
    }

    public SolarPanelBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        int i = 4 * (level.m_45517_(LightLayer.SKY, blockPos) - level.m_7445_());
        float f = level.m_46490_(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.m_14089_((float)f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)60);
        int energyProduction = (int)((float)i / 60.0f * (float)blockEntity.getTier().getPeakFePerTick());
        double moonLightUpgradeModuleEffect = blockEntity.upgradeModuleInventory.getUpgradeModuleModifierEffect(1, UpgradeModuleModifier.MOON_LIGHT);
        if (moonLightUpgradeModuleEffect > 0.0 && (i = 15 - (level.m_45517_(LightLayer.SKY, blockPos) - level.m_7445_())) < 14) {
            i = Mth.m_14045_((int)i, (int)0, (int)15);
            energyProduction += (int)((double)i / 15.0 * (double)blockEntity.getTier().getPeakFePerTick() * moonLightUpgradeModuleEffect);
        }
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + energyProduction));
        SolarPanelBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        BlockPos testPos = blockPos.m_121945_(Direction.DOWN);
        BlockEntity testBlockEntity = level.m_7702_(testPos);
        if (testBlockEntity == null) {
            return;
        }
        LazyOptional energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN.m_122424_());
        if (!energyStorageLazyOptional.isPresent()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return;
        }
        int amount = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract()), false);
        if (amount > 0) {
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(amount, false);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side == Direction.DOWN)) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }
}

