/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.PulverizerRecipe;
import me.jddev0.ep.screen.PulverizerMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PulverizerBlockEntity
extends SimpleRecipeMachineBlockEntity<PulverizerRecipe> {
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1 || i == 2));

    public PulverizerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.PULVERIZER_ENTITY.get(), blockPos, blockState, "pulverizer", PulverizerMenu::new, 3, (RecipeType)EPRecipes.PULVERIZER_TYPE.get(), (int)ModConfigs.COMMON_PULVERIZER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_PULVERIZER_CAPACITY.getValue(), ModConfigs.COMMON_PULVERIZER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_PULVERIZER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(PulverizerRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        ItemStack[] outputs = recipe.generateOutputs(this.f_58857_.f_46441_, false);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, outputs[0].m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + outputs[0].m_41613_()));
        if (!outputs[1].m_41619_()) {
            this.itemHandler.setStackInSlot(2, outputs[1].m_255036_(this.itemHandler.getStackInSlot(2).m_41613_() + outputs[1].m_41613_()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, PulverizerRecipe recipe) {
        ItemStack[] maxOutputs = recipe.getMaxOutputCounts(false);
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, maxOutputs[0]) && (maxOutputs[1].m_41619_() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, maxOutputs[1]));
    }
}

