/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSorterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.screen.ItemConveyorBeltSorterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltSorterBlockEntity
extends BlockEntity
implements MenuProvider,
CheckboxUpdate {
    private static final int TICKS_PER_ITEM = ModConfigs.COMMON_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
    private static final int PATTERN_SLOTS_PER_OUTPUT = 5;
    private final SimpleContainer patternSlots = new SimpleContainer(15){

        public int m_6893_() {
            return 1;
        }
    };
    private final ContainerListener updatePatternListener = container -> this.m_6596_();
    protected final ContainerData data;
    private boolean[] outputBeltConnected = new boolean[]{false, false, false};
    private boolean[] whitelist = new boolean[]{true, true, true};
    private boolean[] ignoreNBT = new boolean[]{false, false, false};
    private boolean loaded;

    public ItemConveyorBeltSorterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.ITEM_CONVEYOR_BELT_SORTER_ENTITY.get(), blockPos, blockState);
        this.patternSlots.m_19164_(this.updatePatternListener);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1, 2 -> {
                        if (ItemConveyorBeltSorterBlockEntity.this.outputBeltConnected[index]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 3, 4, 5 -> {
                        if (ItemConveyorBeltSorterBlockEntity.this.whitelist[index - 3]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 6, 7, 8 -> {
                        if (ItemConveyorBeltSorterBlockEntity.this.ignoreNBT[index - 6]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ItemConveyorBeltSorterBlockEntity.this.outputBeltConnected[index] = value != 0;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        ItemConveyorBeltSorterBlockEntity.this.whitelist[index - 3] = value != 0;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        ItemConveyorBeltSorterBlockEntity.this.ignoreNBT[index - 6] = value != 0;
                    }
                }
            }

            public int m_6499_() {
                return 9;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.item_conveyor_belt_sorter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ItemConveyorBeltSorterMenu(id, inventory, this, (Container)this.patternSlots, this.data);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        int i;
        super.m_183515_(nbt);
        nbt.m_128365_("pattern", this.savePatternContainer());
        for (i = 0; i < 3; ++i) {
            nbt.m_128379_("recipe.whitelist." + i, this.whitelist[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbt.m_128379_("recipe.ignore_nbt." + i, this.ignoreNBT[i]);
        }
    }

    private Tag savePatternContainer() {
        NonNullList items = NonNullList.m_122780_((int)this.patternSlots.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            items.set(i, (Object)this.patternSlots.m_8020_(i));
        }
        return ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        int i;
        super.m_142466_(nbt);
        this.loadPatternContainer(nbt.m_128469_("pattern"));
        for (i = 0; i < 3; ++i) {
            this.whitelist[i] = nbt.m_128471_("recipe.whitelist." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.ignoreNBT[i] = nbt.m_128471_("recipe.ignore_nbt." + i);
        }
    }

    private void loadPatternContainer(CompoundTag tag) {
        this.patternSlots.m_19181_(this.updatePatternListener);
        NonNullList items = NonNullList.m_122780_((int)this.patternSlots.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            this.patternSlots.m_6836_(i, (ItemStack)items.get(i));
        }
        this.patternSlots.m_19164_(this.updatePatternListener);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.loaded) {
            for (int i = 0; i < 3; ++i) {
                Direction facing = (Direction)state.m_61143_((Property)ItemConveyorBeltSorterBlock.FACING);
                Direction outputBeltDirection = switch (i) {
                    case 0 -> facing.m_122427_();
                    case 1 -> facing.m_122424_();
                    case 2 -> facing.m_122428_();
                    default -> null;
                };
                BlockState outputBeltState = level.m_8055_(blockPos.m_121945_(outputBeltDirection));
                blockEntity.setOutputBeltConnected(i, outputBeltState.m_60713_((Block)EPBlocks.ITEM_CONVEYOR_BELT.get()));
            }
            blockEntity.loaded = true;
        }
        if (level.m_46467_() % (long)TICKS_PER_ITEM == 0L) {
            Direction facing = (Direction)state.m_61143_((Property)ItemConveyorBeltSorterBlock.FACING);
            BlockPos inputPos = blockPos.m_121945_(facing);
            BlockState inputBlockState = level.m_8055_(inputPos);
            if (!inputBlockState.m_60713_((Block)EPBlocks.ITEM_CONVEYOR_BELT.get())) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.m_61143_(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().m_122424_() != facing) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            BlockEntity inputBlockEntity = level.m_7702_(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            LazyOptional itemStackStorageLazyOptional = inputBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_());
            if (!itemStackStorageLazyOptional.isPresent()) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            IItemHandler inputBeltItemStackStorage = (IItemHandler)itemStackStorageLazyOptional.orElseGet(null);
            ItemStack itemStackToSort = inputBeltItemStackStorage.getStackInSlot(inputBeltItemStackStorage.getSlots() - 1);
            if (itemStackToSort.m_41619_()) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (!ItemConveyorBeltSorterBlockEntity.filterMatches(blockEntity, i, itemStackToSort)) continue;
                IItemHandler outputBeltItemStackStorage = ItemConveyorBeltSorterBlockEntity.getOutputBeltItemStackStorage(level, blockPos, state, blockEntity, i);
                if (outputBeltItemStackStorage == null) {
                    ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                    return;
                }
                ItemConveyorBeltSorterBlockEntity.tryInsertItemStackIntoOutputBelt(itemStackToSort, inputBeltItemStackStorage, outputBeltItemStackStorage);
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, true);
        }
    }

    private static void updatePoweredState(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity, boolean powered) {
        if (powered != (Boolean)state.m_61143_((Property)ItemConveyorBeltSorterBlock.POWERED)) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ItemConveyorBeltSorterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            ItemConveyorBeltSorterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static boolean filterMatches(ItemConveyorBeltSorterBlockEntity blockEntity, int index, ItemStack itemStackToSort) {
        for (int i = 0; i < 5; ++i) {
            ItemStack patternItemStack = blockEntity.patternSlots.m_8020_(5 * index + i);
            if (patternItemStack.m_41619_() || !(blockEntity.ignoreNBT[index] ? ItemStack.m_41656_((ItemStack)itemStackToSort, (ItemStack)patternItemStack) : ItemStack.m_150942_((ItemStack)itemStackToSort, (ItemStack)patternItemStack))) continue;
            return blockEntity.whitelist[index];
        }
        return !blockEntity.whitelist[index];
    }

    private static IItemHandler getOutputBeltItemStackStorage(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity, int index) {
        Direction direction = (Direction)state.m_61143_((Property)ItemConveyorBeltSorterBlock.FACING);
        switch (index) {
            case 0: {
                Direction direction2 = direction.m_122427_();
                break;
            }
            case 1: {
                Direction direction2 = direction.m_122424_();
                break;
            }
            case 2: {
                Direction direction2 = direction.m_122428_();
                break;
            }
            default: {
                Direction direction2 = direction = null;
            }
        }
        if (direction == null) {
            return null;
        }
        BlockPos outputPos = blockPos.m_121945_(direction);
        BlockState outputBlockState = level.m_8055_(outputPos);
        if (!outputBlockState.m_60713_((Block)EPBlocks.ITEM_CONVEYOR_BELT.get())) {
            return null;
        }
        BlockEntity outputBlockEntity = level.m_7702_(outputPos);
        if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return null;
        }
        LazyOptional itemStackStorageLazyOptional = outputBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_());
        if (!itemStackStorageLazyOptional.isPresent()) {
            return null;
        }
        return (IItemHandler)itemStackStorageLazyOptional.orElseGet(null);
    }

    private static boolean tryInsertItemStackIntoOutputBelt(ItemStack itemStackToSort, IItemHandler inputBeltItemStackStorage, IItemHandler outputBeltItemStackStorage) {
        for (int i = 0; i < outputBeltItemStackStorage.getSlots(); ++i) {
            if (!outputBeltItemStackStorage.insertItem(i, itemStackToSort, false).m_41619_()) continue;
            inputBeltItemStackStorage.extractItem(inputBeltItemStackStorage.getSlots() - 1, 1, false);
            return true;
        }
        return false;
    }

    public void setOutputBeltConnected(int index, boolean outputBeltConnected) {
        this.outputBeltConnected[index] = outputBeltConnected;
        ItemConveyorBeltSorterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void setWhitelist(int index, boolean whitelist) {
        this.whitelist[index] = whitelist;
        ItemConveyorBeltSorterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void setIgnoreNBT(int index, boolean ignoreNBT) {
        this.ignoreNBT[index] = ignoreNBT;
        ItemConveyorBeltSorterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: 
            case 1: 
            case 2: {
                this.setWhitelist(checkboxId, checked);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setIgnoreNBT(checkboxId - 3, checked);
            }
        }
    }
}

