/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import me.jddev0.ep.block.InductionSmelterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.InductionSmelterMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InductionSmelterBlockEntity
extends SimpleRecipeMachineBlockEntity<AlloyFurnaceRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_INDUCTION_SMELTER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> itemHandlerSidedFrontTopBottom = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, i -> i > 2 && i < 5));
    private final LazyOptional<IItemHandler> itemHandlerSidedBack = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i > 2 && i < 5));
    private final LazyOptional<IItemHandler> itemHandlerSidedLeft = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i > 2 && i < 5));
    private final LazyOptional<IItemHandler> itemHandlerSidedRight = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, i -> i > 2 && i < 5));

    public InductionSmelterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.INDUCTION_SMELTER_ENTITY.get(), blockPos, blockState, "induction_smelter", InductionSmelterMenu::new, 5, (RecipeType)EPRecipes.ALLOY_FURNACE_TYPE.get(), 1, (int)ModConfigs.COMMON_INDUCTION_SMELTER_CAPACITY.getValue(), ModConfigs.COMMON_INDUCTION_SMELTER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_INDUCTION_SMELTER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (InductionSmelterBlockEntity.this.f_58857_ == null || InductionSmelterBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)AlloyFurnaceRecipe.Type.INSTANCE).stream().map(AlloyFurnaceRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4 -> false;
                    default -> false;
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(InductionSmelterBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        InductionSmelterBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                InductionSmelterBlockEntity.this.m_6596_();
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)InductionSmelterBlock.FACING);
            if (facing.m_122424_() == side) {
                return this.itemHandlerSidedBack.cast();
            }
            if (facing.m_122427_() == side) {
                return this.itemHandlerSidedLeft.cast();
            }
            if (facing.m_122428_() == side) {
                return this.itemHandlerSidedRight.cast();
            }
            return this.itemHandlerSidedFrontTopBottom.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void onHasEnoughEnergy() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    protected void onHasNotEnoughEnergy() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected double getRecipeDependentRecipeDuration(AlloyFurnaceRecipe recipe) {
        return (float)recipe.getTicks() * RECIPE_DURATION_MULTIPLIER / 2.0f;
    }

    @Override
    protected void craftItem(AlloyFurnaceRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = recipe.getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).m_41619_();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input().test(item) || item.m_41613_() < input.count()) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        ItemStack[] outputs = recipe.generateOutputs(this.f_58857_.f_46441_);
        this.itemHandler.setStackInSlot(3, outputs[0].m_255036_(this.itemHandler.getStackInSlot(3).m_41613_() + outputs[0].m_41613_()));
        if (!outputs[1].m_41619_()) {
            this.itemHandler.setStackInSlot(4, outputs[1].m_255036_(this.itemHandler.getStackInSlot(4).m_41613_() + outputs[1].m_41613_()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, AlloyFurnaceRecipe recipe) {
        ItemStack[] maxOutputs = recipe.getMaxOutputCounts();
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3, maxOutputs[0]) && (maxOutputs[1].m_41619_() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, maxOutputs[1]));
    }
}

