/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.SimpleRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTransposerBlockEntity
extends SimpleRecipeFluidMachineBlockEntity<FluidTank, FluidTransposerRecipe>
implements CheckboxUpdate {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_FLUID_TRANSPOSER_TANK_CAPACITY.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));
    private Mode mode = Mode.EMPTYING;

    public FluidTransposerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.FLUID_TRANSPOSER_ENTITY.get(), blockPos, blockState, "fluid_transposer", FluidTransposerMenu::new, 2, (RecipeType)EPRecipes.FLUID_TRANSPOSER_TYPE.get(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_TRANSPOSER_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_ENERGY_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(FluidTransposerBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(FluidTransposerBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(FluidTransposerBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (FluidTransposerBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> FluidTransposerBlockEntity.this.mode.ordinal();
                    case 8 -> FluidTransposerBlockEntity.this.redstoneMode.ordinal();
                    case 9 -> FluidTransposerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        FluidTransposerBlockEntity.this.progress = ByteUtils.with2Bytes(FluidTransposerBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        FluidTransposerBlockEntity.this.maxProgress = ByteUtils.with2Bytes(FluidTransposerBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        FluidTransposerBlockEntity.this.mode = Mode.fromIndex(value);
                        break;
                    }
                    case 8: {
                        FluidTransposerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 9: {
                        FluidTransposerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 10;
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FluidTransposerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (FluidTransposerBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(FluidTransposerBlockEntity.this.f_58857_, FluidTransposerBlockEntity.this.recipeType, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(FluidTransposerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        FluidTransposerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidTransposerBlockEntity.this.m_6596_();
                FluidTransposerBlockEntity.this.syncFluidToPlayers(32);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || FluidTransposerBlockEntity.this.f_58857_ == null) {
                    return false;
                }
                return FluidTransposerBlockEntity.this.f_58857_.m_7465_().m_44013_(FluidTransposerBlockEntity.this.recipeType).stream().map(FluidTransposerRecipe::getFluid).anyMatch(fluidStack -> stack.isFluidEqual(fluidStack));
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("mode", this.mode.ordinal());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mode = Mode.fromIndex(nbt.m_128451_("mode"));
    }

    @Override
    protected Optional<FluidTransposerRecipe> getRecipeFor(Container inventory) {
        return this.f_58857_.m_7465_().m_44013_(this.recipeType).stream().filter(recipe -> recipe.getMode() == this.mode).filter(recipe -> recipe.m_5818_(inventory, this.f_58857_)).filter(recipe -> this.mode == Mode.EMPTYING && ((FluidTank)this.fluidStorage).isEmpty() || recipe.getFluid().isFluidEqual(((FluidTank)this.fluidStorage).getFluid())).findFirst();
    }

    @Override
    protected void craftItem(FluidTransposerRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        FluidStack fluid = recipe.getFluid().copy();
        if (this.mode == Mode.EMPTYING) {
            ((FluidTank)this.fluidStorage).fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        } else {
            ((FluidTank)this.fluidStorage).drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, FluidTransposerRecipe recipe) {
        int fluidAmountInTank = ((FluidTank)this.fluidStorage).getFluid().getAmount();
        int fluidAmountInRecipe = recipe.getFluid().getAmount();
        return this.f_58857_ != null && (this.mode == Mode.EMPTYING ? ((FluidTank)this.fluidStorage).getCapacity() - fluidAmountInTank : fluidAmountInTank) >= fluidAmountInRecipe && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, recipe.m_8043_(this.f_58857_.m_9598_()));
    }

    public void setMode(boolean isFillingMode) {
        this.mode = isFillingMode ? Mode.FILLING : Mode.EMPTYING;
        this.resetProgress();
        FluidTransposerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setMode(checked);
            }
        }
    }

    public static enum Mode implements StringRepresentable
    {
        EMPTYING,
        FILLING;


        @NotNull
        public static Mode fromIndex(int index) {
            Mode[] values = Mode.values();
            if (index < 0 || index >= values.length) {
                return EMPTYING;
            }
            return values[index];
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

