/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.FluidPipeBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity
extends BlockEntity {
    private final FluidPipeBlock.Tier tier;
    private final int maxTransfer;
    private final IFluidHandler fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    private final Map<Pair<BlockPos, Direction>, IFluidHandler> producers = new HashMap<Pair<BlockPos, Direction>, IFluidHandler>();
    private final Map<Pair<BlockPos, Direction>, IFluidHandler> consumers = new HashMap<Pair<BlockPos, Direction>, IFluidHandler>();
    private final List<BlockPos> pipeBlocks = new LinkedList<BlockPos>();

    public static BlockEntityType<FluidPipeBlockEntity> getEntityTypeFromTier(FluidPipeBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidPipeBlock.Tier.IRON -> (BlockEntityType)EPBlockEntities.IRON_FLUID_PIPE_ENTITY.get();
            case FluidPipeBlock.Tier.GOLDEN -> (BlockEntityType)EPBlockEntities.GOLDEN_FLUID_PIPE_ENTITY.get();
        };
    }

    public FluidPipeBlockEntity(BlockPos blockPos, BlockState blockState, FluidPipeBlock.Tier tier) {
        super(FluidPipeBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.maxTransfer = tier.getTransferRate();
        this.fluidStorage = new IFluidHandler(){

            public int getTanks() {
                return 0;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return 0;
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        };
    }

    public FluidPipeBlock.Tier getTier() {
        return this.tier;
    }

    public Map<Pair<BlockPos, Direction>, IFluidHandler> getProducers() {
        return this.producers;
    }

    public Map<Pair<BlockPos, Direction>, IFluidHandler> getConsumers() {
        return this.consumers;
    }

    public List<BlockPos> getPipeBlocks() {
        return this.pipeBlocks;
    }

    public static void updateConnections(Level level, BlockPos blockPos, BlockState state, FluidPipeBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.pipeBlocks.clear();
        for (Direction direction : Direction.values()) {
            IFluidHandler fluidStorage;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null) continue;
            if (testBlockEntity instanceof FluidPipeBlockEntity) {
                FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)testBlockEntity;
                if (fluidPipeBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.pipeBlocks.add(testPos);
                continue;
            }
            LazyOptional fluidStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_());
            if (!fluidStorageLazyOptional.isPresent() || (fluidStorage = (IFluidHandler)fluidStorageLazyOptional.orElse(null)).getTanks() == 0) continue;
            EPBlockStateProperties.PipeConnection pipeConnection = (EPBlockStateProperties.PipeConnection)((Object)state.m_61143_(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
            if (pipeConnection.isExtract()) {
                blockEntity.producers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.m_122424_()), fluidStorage);
                continue;
            }
            if (!pipeConnection.isInsert()) continue;
            blockEntity.consumers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.m_122424_()), fluidStorage);
        }
    }

    public static List<IFluidHandler> getConnectedConsumers(Level level, BlockPos blockPos, List<BlockPos> checkedPipes) {
        LinkedList<IFluidHandler> consumers = new LinkedList<IFluidHandler>();
        LinkedList<BlockPos> pipeBlocksLeft = new LinkedList<BlockPos>();
        pipeBlocksLeft.add(blockPos);
        checkedPipes.add(blockPos);
        while (pipeBlocksLeft.size() > 0) {
            BlockPos checkPos = (BlockPos)pipeBlocksLeft.pop();
            BlockEntity blockEntity = level.m_7702_(checkPos);
            if (!(blockEntity instanceof FluidPipeBlockEntity)) continue;
            FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity;
            fluidPipeBlockEntity.getPipeBlocks().forEach(pos -> {
                if (!checkedPipes.contains(pos)) {
                    checkedPipes.add((BlockPos)pos);
                    pipeBlocksLeft.add((BlockPos)pos);
                }
            });
            consumers.addAll(fluidPipeBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidPipeBlockEntity blockEntity) {
        int realInsert;
        FluidStack realExtract;
        int consumptionSum;
        LinkedList<Integer> fluidConsumptionValues;
        LinkedList<IFluidHandler> fluidConsumption;
        int productionSum;
        LinkedList<Integer> fluidProductionValues;
        FluidStack extractedFluidType;
        LinkedList<IFluidHandler> fluidProduction;
        if (level.f_46443_) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, blockPos, state, blockEntity);
        List<IFluidHandler> consumers = null;
        LinkedList<FluidStack> alreadyCheckedFluidTypes = new LinkedList<FluidStack>();
        while (true) {
            int i;
            fluidProduction = new LinkedList<IFluidHandler>();
            extractedFluidType = FluidStack.EMPTY;
            fluidProductionValues = new LinkedList<Integer>();
            productionSum = 0;
            for (IFluidHandler fluidStorage : blockEntity.producers.values()) {
                boolean extractedAnything = false;
                int fluidProductionValuesIndex = -1;
                block2: for (i = 0; i < fluidStorage.getTanks(); ++i) {
                    FluidStack fluidStackInTank = fluidStorage.getFluidInTank(i);
                    if (fluidStackInTank.isEmpty()) continue;
                    boolean wasExtractedFluidTypeEmpty = extractedFluidType.isEmpty();
                    if (wasExtractedFluidTypeEmpty) {
                        for (FluidStack alreadyCheckedFluidType : alreadyCheckedFluidTypes) {
                            if (!alreadyCheckedFluidType.isFluidEqual(fluidStackInTank)) continue;
                            continue block2;
                        }
                        extractedFluidType = fluidStackInTank.copy();
                        extractedFluidType.setAmount(blockEntity.maxTransfer);
                    }
                    if (!fluidStackInTank.isFluidEqual(extractedFluidType)) continue;
                    FluidStack extracted = fluidStorage.drain(extractedFluidType.copy(), IFluidHandler.FluidAction.SIMULATE);
                    if (extracted.getAmount() <= 0 || extracted.isEmpty() || !extracted.isFluidEqual(extractedFluidType)) {
                        if (!wasExtractedFluidTypeEmpty) continue;
                        extractedFluidType = FluidStack.EMPTY;
                        continue;
                    }
                    extractedAnything = true;
                    if (fluidProductionValuesIndex == -1) {
                        fluidProductionValuesIndex = fluidProductionValues.size();
                        fluidProductionValues.add(extracted.getAmount());
                    } else {
                        fluidProductionValues.set(fluidProductionValuesIndex, (Integer)fluidProductionValues.get(fluidProductionValuesIndex) + extracted.getAmount());
                    }
                    productionSum += extracted.getAmount();
                }
                if (!extractedAnything) continue;
                fluidProduction.add(fluidStorage);
            }
            if (productionSum <= 0 || extractedFluidType.isEmpty()) {
                return;
            }
            fluidConsumption = new LinkedList<IFluidHandler>();
            fluidConsumptionValues = new LinkedList<Integer>();
            consumptionSum = 0;
            if (consumers == null) {
                consumers = FluidPipeBlockEntity.getConnectedConsumers(level, blockPos, new LinkedList<BlockPos>());
            }
            extractedFluidType.setAmount(Math.min(blockEntity.maxTransfer, productionSum));
            for (IFluidHandler fluidStorage : consumers) {
                boolean receivedAnything = false;
                int fluidConsumptionValuesIndex = -1;
                for (i = 0; i < fluidStorage.getTanks(); ++i) {
                    FluidStack extractedFluidTypeTmp = extractedFluidType.copy();
                    int received = fluidStorage.fill(extractedFluidTypeTmp, IFluidHandler.FluidAction.SIMULATE);
                    if (received <= 0) continue;
                    receivedAnything = true;
                    if (fluidConsumptionValuesIndex == -1) {
                        fluidConsumptionValuesIndex = fluidConsumptionValues.size();
                        fluidConsumptionValues.add(received);
                    } else {
                        fluidConsumptionValues.set(fluidConsumptionValuesIndex, (Integer)fluidConsumptionValues.get(fluidConsumptionValuesIndex) + received);
                    }
                    consumptionSum += received;
                }
                if (!receivedAnything) continue;
                fluidConsumption.add(fluidStorage);
            }
            if (consumptionSum > 0) break;
            alreadyCheckedFluidTypes.add(extractedFluidType);
        }
        int transferLeft = Math.min(productionSum, consumptionSum);
        LinkedList<Integer> fluidProductionDistributed = new LinkedList<Integer>();
        for (int i = 0; i < fluidProduction.size(); ++i) {
            fluidProductionDistributed.add(0);
        }
        int productionLeft = transferLeft;
        int divisor = fluidProduction.size();
        block7: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (int i = 0; i < fluidProductionValues.size(); ++i) {
                int productionDistributed = (Integer)fluidProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)fluidProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                fluidProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block7;
            }
        }
        int realProduction = 0;
        int realProductionAmountMissing = 0;
        for (int i = 0; i < fluidProduction.size(); ++i) {
            int amount = (Integer)fluidProductionDistributed.get(i) + realProductionAmountMissing;
            if (amount <= 0) continue;
            FluidStack extract = extractedFluidType.copy();
            extract.setAmount(amount);
            realExtract = ((IFluidHandler)fluidProduction.get(i)).drain(extract, IFluidHandler.FluidAction.EXECUTE);
            realProduction += realExtract.getAmount();
            realProductionAmountMissing = amount - realExtract.getAmount();
        }
        if (realProductionAmountMissing > 0) {
            for (IFluidHandler producer : fluidProduction) {
                FluidStack extract = extractedFluidType.copy();
                extract.setAmount(realProductionAmountMissing);
                realExtract = producer.drain(extract, IFluidHandler.FluidAction.EXECUTE);
                realProduction += realExtract.getAmount();
                if ((realProductionAmountMissing -= realExtract.getAmount()) != 0) continue;
                break;
            }
        }
        LinkedList<Integer> fluidConsumptionDistributed = new LinkedList<Integer>();
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            fluidConsumptionDistributed.add(0);
        }
        int consumptionLeft = realProduction;
        divisor = fluidConsumption.size();
        block12: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < fluidConsumptionValues.size(); ++i) {
                int consumptionDistributed = (Integer)fluidConsumptionDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)fluidConsumptionValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                fluidConsumptionDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block12;
            }
        }
        int realConsumptionAmountMissing = 0;
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            int amount = (Integer)fluidConsumptionDistributed.get(i) + realConsumptionAmountMissing;
            if (amount <= 0) continue;
            FluidStack insert = extractedFluidType.copy();
            insert.setAmount(amount);
            realInsert = ((IFluidHandler)fluidConsumption.get(i)).fill(insert, IFluidHandler.FluidAction.EXECUTE);
            realConsumptionAmountMissing = amount - realInsert;
        }
        if (realConsumptionAmountMissing > 0) {
            for (IFluidHandler consumer : fluidConsumption) {
                FluidStack insert = extractedFluidType.copy();
                insert.setAmount(realConsumptionAmountMissing);
                realInsert = consumer.fill(insert, IFluidHandler.FluidAction.EXECUTE);
                if ((realConsumptionAmountMissing -= realInsert) != 0) continue;
                break;
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
    }
}

