/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidFillerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidFillerMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidFillerBlockEntity
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler, FluidTank> {
    public static final int MAX_FLUID_FILLING_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i != 0) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!fluidStorageLazyOptional.isPresent()) {
            return true;
        }
        IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
        for (int j = 0; j < fluidStorage.getTanks(); ++j) {
            FluidStack fluidStack = fluidStorage.getFluidInTank(j);
            if (fluidStorage.getTankCapacity(j) <= fluidStack.getAmount() || !((FluidTank)this.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(j, ((FluidTank)this.fluidStorage).getFluid())) && !fluidStack.isFluidEqual(((FluidTank)this.fluidStorage).getFluid())) continue;
            return false;
        }
        return true;
    }));
    private int fluidFillingLeft = -1;
    private int fluidFillingSumPending = 0;

    public FluidFillerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.FLUID_FILLER_ENTITY.get(), blockPos, blockState, "fluid_filler", ModConfigs.COMMON_FLUID_FILLER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_FILLER_TRANSFER_RATE.getValue(), 1, FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_FLUID_FILLER_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                FluidFillerBlockEntity.this.m_6596_();
                FluidFillerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FluidFillerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(FluidFillerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()))) {
                        FluidFillerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidFillerBlockEntity.this.m_6596_();
                FluidFillerBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(FluidFillerBlockEntity.this.fluidFillingLeft, index);
                    case 2, 3 -> ByteUtils.get2Bytes(FluidFillerBlockEntity.this.fluidFillingSumPending, index - 2);
                    case 4 -> FluidFillerBlockEntity.this.redstoneMode.ordinal();
                    case 5 -> FluidFillerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        FluidFillerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 5: {
                        FluidFillerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidFillerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("recipe.fluid_filling_left", (Tag)IntTag.m_128679_((int)this.fluidFillingLeft));
        nbt.m_128365_("recipe.fluid_filling_sum_pending", (Tag)IntTag.m_128679_((int)this.fluidFillingSumPending));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidFillingLeft = nbt.m_128451_("recipe.fluid_filling_left");
        this.fluidFillingSumPending = nbt.m_128451_("recipe.fluid_filling_sum_pending");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidFillerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)FluidFillerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            int fluidFillingSum = 0;
            int fluidFillingLeftSum = 0;
            if (((FluidTank)blockEntity.fluidStorage).getFluidAmount() - blockEntity.fluidFillingSumPending <= 0) {
                return;
            }
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)ENERGY_USAGE_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() < energyConsumptionPerTick) {
                return;
            }
            LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!fluidStorageLazyOptional.isPresent()) {
                return;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (fluidStorage.getTankCapacity(i) <= fluidStack.getAmount() || !((FluidTank)blockEntity.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(i, ((FluidTank)blockEntity.fluidStorage).getFluid())) && !fluidStack.isFluidEqual(((FluidTank)blockEntity.fluidStorage).getFluid())) continue;
                fluidFillingSum += Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount() - blockEntity.fluidFillingSumPending - fluidFillingSum, Math.min(fluidStorage.getTankCapacity(i) - fluidStack.getAmount(), MAX_FLUID_FILLING_PER_TICK - fluidFillingSum));
                fluidFillingLeftSum += fluidStorage.getTankCapacity(i) - fluidStack.getAmount();
            }
            if (fluidFillingSum == 0) {
                return;
            }
            blockEntity.fluidFillingLeft = fluidFillingLeftSum;
            blockEntity.fluidFillingSumPending += fluidFillingSum;
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
            int fluidSumFillable = Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount(), blockEntity.fluidFillingSumPending);
            FluidStack fluidStackToFill = blockEntity.getFluid(0);
            int fluidSumFilled = fluidStorage.fill(new FluidStack(fluidStackToFill.getFluid(), fluidSumFillable, fluidStackToFill.getTag()), IFluidHandler.FluidAction.EXECUTE);
            if (fluidSumFilled <= 0) {
                FluidFillerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            blockEntity.itemHandler.setStackInSlot(0, fluidStorage.getContainer());
            ((FluidTank)blockEntity.fluidStorage).drain(fluidSumFilled, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.fluidFillingSumPending -= fluidSumFilled;
            blockEntity.fluidFillingLeft = fluidFillingLeftSum - fluidSumFilled;
            if (blockEntity.fluidFillingLeft <= 0) {
                blockEntity.resetProgress();
            }
            FluidFillerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            FluidFillerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.fluidFillingLeft = -1;
        this.fluidFillingSumPending = 0;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!fluidStorageLazyOptional.isPresent()) {
                return false;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (fluidStorage.getTankCapacity(i) <= fluidStack.getAmount() || !((FluidTank)this.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(i, ((FluidTank)this.fluidStorage).getFluid())) && !fluidStack.isFluidEqual(((FluidTank)this.fluidStorage).getFluid())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

