/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.MenuFluidStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends MenuFluidStorageBlockEntity<FluidTank> {
    private int progress;
    private int maxProgress = ModConfigs.COMMON_DRAIN_DRAIN_DURATION.getValue();

    public DrainBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.DRAIN_ENTITY.get(), blockPos, blockState, "drain", FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_DRAIN_FLUID_TANK_CAPACITY.getValue() * 1000);
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                DrainBlockEntity.this.m_6596_();
                DrainBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(DrainBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(DrainBlockEntity.this.maxProgress, index - 2);
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        DrainBlockEntity.this.progress = ByteUtils.with2Bytes(DrainBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        DrainBlockEntity.this.maxProgress = ByteUtils.with2Bytes(DrainBlockEntity.this.maxProgress, (short)value, index - 2);
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncFluidToPlayer(player);
        return new DrainMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("drain.progress", (Tag)IntTag.m_128679_((int)this.progress));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("drain.progress");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, DrainBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (DrainBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                blockEntity.resetProgress(blockPos, state);
                DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (blockEntity.progress < blockEntity.maxProgress) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                BucketPickup aboveBlock;
                ItemStack bucketItemStack;
                BlockPos aboveBlockPos = blockPos.m_7494_();
                BlockState aboveBlockState = level.m_8055_(aboveBlockPos);
                Block block = aboveBlockState.m_60734_();
                if (block instanceof BucketPickup && !(bucketItemStack = (aboveBlock = (BucketPickup)block).m_142598_((LevelAccessor)level, aboveBlockPos, aboveBlockState)).m_41619_()) {
                    FluidStack fluidStack;
                    IFluidHandlerItem fluidStorage;
                    level.m_142346_(null, GameEvent.f_157816_, aboveBlockPos);
                    LazyOptional fluidStorageLazyOptional = bucketItemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                    if (fluidStorageLazyOptional.isPresent() && (fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null)).getTanks() == 1 && !(fluidStack = fluidStorage.getFluidInTank(0)).isEmpty()) {
                        ((FluidTank)blockEntity.fluidStorage).fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                blockEntity.resetProgress(blockPos, state);
            }
            DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress(blockPos, state);
            DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
    }

    private static boolean hasRecipe(DrainBlockEntity blockEntity) {
        BlockPos blockPos;
        BlockPos aboveBlockPos;
        Level level = blockEntity.m_58904_();
        BlockState aboveBlockState = level.m_8055_(aboveBlockPos = (blockPos = blockEntity.m_58899_()).m_7494_());
        if (!(aboveBlockState.m_60734_() instanceof BucketPickup)) {
            return false;
        }
        FluidState fluidState = level.m_6425_(aboveBlockPos);
        if (fluidState.m_76178_()) {
            return false;
        }
        return ((FluidTank)blockEntity.fluidStorage).fill(new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000;
    }
}

