/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.CrystalGrowthChamberRecipe;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.screen.CrystalGrowthChamberMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystalGrowthChamberBlockEntity
extends SimpleRecipeMachineBlockEntity<CrystalGrowthChamberRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_CRYSTAL_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));

    public CrystalGrowthChamberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.CRYSTAL_GROWTH_CHAMBER_ENTITY.get(), blockPos, blockState, "crystal_growth_chamber", CrystalGrowthChamberMenu::new, 2, (RecipeType)EPRecipes.CRYSTAL_GROWTH_CHAMBER_TYPE.get(), 1, (int)ModConfigs.COMMON_CRYSTAL_GROWTH_CHAMBER_CAPACITY.getValue(), ModConfigs.COMMON_CRYSTAL_GROWTH_CHAMBER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_CRYSTAL_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                CrystalGrowthChamberBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (CrystalGrowthChamberBlockEntity.this.f_58857_ == null || CrystalGrowthChamberBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)CrystalGrowthChamberRecipe.Type.INSTANCE).stream().map(CrystalGrowthChamberRecipe::getInput).anyMatch(ingredient -> ingredient.test(stack))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(CrystalGrowthChamberBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        CrystalGrowthChamberBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected double getRecipeDependentRecipeDuration(CrystalGrowthChamberRecipe recipe) {
        return (float)recipe.getTicks() * RECIPE_DURATION_MULTIPLIER;
    }

    @Override
    protected void craftItem(CrystalGrowthChamberRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.extractItem(0, recipe.getInputCount(), false);
        ItemStack output = recipe.generateOutput(this.f_58857_.f_46441_);
        if (!output.m_41619_()) {
            this.itemHandler.setStackInSlot(1, output.m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + output.m_41613_()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, CrystalGrowthChamberRecipe recipe) {
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, recipe.getMaxOutputCount());
    }
}

