/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.energy.InfinityEnergyStorage;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.screen.CreativeBatteryBoxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeBatteryBoxBlockEntity
extends MenuEnergyStorageBlockEntity<InfinityEnergyStorage>
implements CheckboxUpdate {
    private boolean energyProduction = true;
    private boolean energyConsumption;

    public CreativeBatteryBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.CREATIVE_BATTERY_BOX_ENTITY.get(), blockPos, blockState, "creative_battery_box", Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected InfinityEnergyStorage initEnergyStorage() {
        return new InfinityEnergyStorage(){

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                return CreativeBatteryBoxBlockEntity.this.energyProduction ? super.extractEnergy(maxExtract, simulate) : 0;
            }

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return CreativeBatteryBoxBlockEntity.this.energyConsumption ? super.receiveEnergy(maxReceive, simulate) : 0;
            }

            @Override
            protected void onChange() {
                CreativeBatteryBoxBlockEntity.this.m_6596_();
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> {
                        if (CreativeBatteryBoxBlockEntity.this.energyProduction) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 1 -> {
                        if (CreativeBatteryBoxBlockEntity.this.energyConsumption) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CreativeBatteryBoxBlockEntity.this.energyProduction = value != 0;
                        break;
                    }
                    case 1: {
                        CreativeBatteryBoxBlockEntity.this.energyConsumption = value != 0;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CreativeBatteryBoxMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("energy_production", this.energyProduction);
        nbt.m_128379_("energy_consumption", this.energyConsumption);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyProduction = !nbt.m_128441_("energy_production") || nbt.m_128471_("energy_production");
        this.energyConsumption = nbt.m_128471_("energy_consumption");
    }

    public void setEnergyProduction(boolean energyProduction) {
        this.energyProduction = energyProduction;
        CreativeBatteryBoxBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void setEnergyConsumption(boolean energyConsumption) {
        this.energyConsumption = energyConsumption;
        CreativeBatteryBoxBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setEnergyProduction(checked);
                break;
            }
            case 1: {
                this.setEnergyConsumption(checked);
            }
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        CreativeBatteryBoxBlockEntity.transferInfiniteEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferInfiniteEnergy(Level level, BlockPos blockPos, BlockState state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.energyProduction) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive()) continue;
            int received = energyStorage.receiveEnergy(energyStorage.getMaxEnergyStored(), true);
            energyStorage.receiveEnergy(received, false);
        }
    }
}

