/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.ChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.ChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i != 0) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        if (this.f_58857_ != null && RecipeUtils.isResultOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return true;
        }
        if (this.f_58857_ == null || RecipeUtils.isIngredientOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return false;
        }
        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return true;
        }
        return energyStorage.receiveEnergy(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive(), true) == 0;
    }));
    private int energyConsumptionLeft = -1;

    public ChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.CHARGER_ENTITY.get(), blockPos, blockState, "charger", ModConfigs.COMMON_CHARGER_CAPACITY.getValue(), ModConfigs.COMMON_CHARGER_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ChargerBlockEntity.this.m_6596_();
                ChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ChargerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    if (ChargerBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(ChargerBlockEntity.this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
                        return true;
                    }
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent()) {
                        return false;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                    return energyStorage.canReceive();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(ChargerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()))) {
                        ChargerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(ChargerBlockEntity.this.energyConsumptionLeft, index);
                    case 2 -> ChargerBlockEntity.this.redstoneMode.ordinal();
                    case 3 -> ChargerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        ChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 3: {
                        ChargerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new ChargerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)ChargerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            int energyConsumptionPerTick;
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, level);
            if (recipe.isPresent()) {
                if (blockEntity.energyConsumptionLeft == -1) {
                    blockEntity.energyConsumptionLeft = (int)((float)((ChargerRecipe)recipe.get()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                }
                if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                    ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft, Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()));
            } else {
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent()) {
                    return;
                }
                IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                if (!energyStorage.canReceive()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
                if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                    ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), false);
            }
            if (blockEntity.energyConsumptionLeft < 0 || energyConsumptionPerTick < 0) {
                blockEntity.resetProgress();
                ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
            blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
            if (blockEntity.energyConsumptionLeft <= 0) {
                recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(0, chargerRecipe.m_8043_(level.m_9598_()).m_255036_(1)));
                blockEntity.resetProgress();
            }
            ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.energyConsumptionLeft = -1;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return recipe.isPresent();
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

