/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AutoCrafterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCrafterBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler>
implements CheckboxUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    public static final int ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue();
    public static final int RECIPE_DURATION = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private boolean secondaryExtractMode;
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 3, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.getStackInSlot(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.getStackInSlot(i.intValue()))));
    private final SimpleContainer patternSlots = new SimpleContainer(9){

        public int m_6893_() {
            return 1;
        }
    };
    private final SimpleContainer patternResultSlots = new SimpleContainer(1);
    private final ContainerListener updatePatternListener = container -> this.updateRecipe();
    private boolean hasRecipeLoaded = false;
    private ResourceLocation recipeIdForSetRecipe;
    private CraftingRecipe craftingRecipe;
    private CraftingContainer oldCopyOfRecipe;
    private final AbstractContainerMenu dummyContainerMenu = new AbstractContainerMenu(null, -1){

        public ItemStack m_7648_(Player player, int index) {
            return null;
        }

        public boolean m_6875_(Player player) {
            return false;
        }

        public void m_6199_(Container container) {
        }
    };
    private int progress;
    private int maxProgress;
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    private boolean ignoreNBT;

    public AutoCrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.AUTO_CRAFTER_ENTITY.get(), blockPos, blockState, "auto_crafter", ModConfigs.COMMON_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_AUTO_CRAFTER_TRANSFER_RATE.getValue(), 18, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.patternSlots.m_19164_(this.updatePatternListener);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AutoCrafterBlockEntity.this.m_6596_();
                AutoCrafterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AutoCrafterBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot < 0 || slot >= 18) {
                    return super.isItemValid(slot, stack);
                }
                return slot >= 3;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (AutoCrafterBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> {
                        if (AutoCrafterBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 8 -> {
                        if (AutoCrafterBlockEntity.this.secondaryExtractMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> AutoCrafterBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> AutoCrafterBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AutoCrafterBlockEntity.this.progress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AutoCrafterBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        AutoCrafterBlockEntity.this.ignoreNBT = value != 0;
                        break;
                    }
                    case 8: {
                        AutoCrafterBlockEntity.this.secondaryExtractMode = value != 0;
                        break;
                    }
                    case 9: {
                        AutoCrafterBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        AutoCrafterBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 11;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AutoCrafterMenu(id, inventory, this, this.upgradeModuleInventory, (Container)this.patternSlots, (Container)this.patternResultSlots, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        NonNullList items = NonNullList.m_122780_((int)this.patternSlots.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            items.set(i, (Object)this.patternSlots.m_8020_(i));
        }
        nbt.m_128365_("pattern", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
        if (this.craftingRecipe != null) {
            nbt.m_128365_("recipe.id", (Tag)StringTag.m_129297_((String)this.craftingRecipe.m_6423_().toString()));
        }
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.max_progress", (Tag)IntTag.m_128679_((int)this.maxProgress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128379_("ignore_nbt", this.ignoreNBT);
        nbt.m_128379_("secondary_extract_mode", this.secondaryExtractMode);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.patternSlots.m_19181_(this.updatePatternListener);
        NonNullList items = NonNullList.m_122780_((int)this.patternSlots.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("pattern"), (NonNullList)items);
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            this.patternSlots.m_6836_(i, (ItemStack)items.get(i));
        }
        this.patternSlots.m_19164_(this.updatePatternListener);
        if (nbt.m_128441_("recipe.id")) {
            Tag tag = nbt.m_128423_("recipe.id");
            if (!(tag instanceof StringTag)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            StringTag stringTag = (StringTag)tag;
            this.recipeIdForSetRecipe = ResourceLocation.m_135820_((String)stringTag.m_7916_());
        }
        this.progress = nbt.m_128451_("recipe.progress");
        this.maxProgress = nbt.m_128451_("recipe.max_progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.ignoreNBT = nbt.m_128471_("ignore_nbt");
        this.secondaryExtractMode = nbt.m_128471_("secondary_extract_mode");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AutoCrafterBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.hasRecipeLoaded) {
            blockEntity.updateRecipe();
            if (blockEntity.craftingRecipe == null) {
                blockEntity.resetProgress();
            }
            AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)AutoCrafterBlock.POWERED))) {
            return;
        }
        int itemCount = 0;
        for (int i = 0; i < blockEntity.patternSlots.m_6643_(); ++i) {
            if (blockEntity.patternSlots.m_8020_(i).m_41619_()) continue;
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        if (blockEntity.craftingRecipe != null && (blockEntity.progress > 0 || blockEntity.canInsertItemsIntoOutputSlots() && blockEntity.canExtractItemsFromInput())) {
            if (!blockEntity.canInsertItemsIntoOutputSlots() || !blockEntity.canExtractItemsFromInput()) {
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)Math.ceil((double)RECIPE_DURATION / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
            }
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)(itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (blockEntity.progress == 0) {
                if (!blockEntity.canExtractItemsFromInput()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * blockEntity.maxProgress;
            }
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                blockEntity.resetProgress();
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    SimpleContainer patternSlotsForRecipe = blockEntity.ignoreNBT ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots) : blockEntity.patternSlots;
                    TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(blockEntity.dummyContainerMenu, 3, 3);
                    for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
                        copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
                    }
                    blockEntity.extractItems();
                    blockEntity.craftItem((CraftingContainer)copyOfPatternSlots);
                }
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    public void resetProgressAndMarkAsChanged() {
        this.resetProgress();
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void cycleRecipe() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        List<CraftingRecipe> recipes = this.getRecipesFor((CraftingContainer)copyOfPatternSlots, this.f_58857_);
        if (recipes.isEmpty()) {
            this.updateRecipe();
            return;
        }
        if (this.recipeIdForSetRecipe == null) {
            this.recipeIdForSetRecipe = this.craftingRecipe == null || this.craftingRecipe.m_6423_() == null ? recipes.get(0).m_6423_() : this.craftingRecipe.m_6423_();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).m_6423_(), this.recipeIdForSetRecipe)) continue;
            this.recipeIdForSetRecipe = recipes.get((i + 1) % recipes.size()).m_6423_();
            break;
        }
        this.updateRecipe();
    }

    public void setRecipeIdForSetRecipe(ResourceLocation recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe = recipeIdForSetRecipe;
        this.updateRecipe();
    }

    private void updateRecipe() {
        if (this.f_58857_ == null) {
            return;
        }
        CraftingRecipe oldRecipe = null;
        ItemStack oldResult = null;
        if (this.hasRecipeLoaded && this.craftingRecipe != null && this.oldCopyOfRecipe != null) {
            oldRecipe = this.craftingRecipe;
            oldResult = this.craftingRecipe instanceof CustomRecipe ? this.craftingRecipe.m_5874_((Container)this.oldCopyOfRecipe, this.f_58857_.m_9598_()) : this.craftingRecipe.m_8043_(this.f_58857_.m_9598_());
        }
        this.hasRecipeLoaded = true;
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        Optional<Pair<ResourceLocation, CraftingRecipe>> recipe = this.getRecipeFor((CraftingContainer)copyOfPatternSlots, this.f_58857_, this.recipeIdForSetRecipe);
        if (recipe.isPresent()) {
            this.craftingRecipe = (CraftingRecipe)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe != null && !Objects.equals(this.craftingRecipe.m_6423_(), this.recipeIdForSetRecipe)) {
                this.recipeIdForSetRecipe = this.craftingRecipe.m_6423_();
                this.resetProgress();
            }
            ItemStack resultItemStack = this.craftingRecipe instanceof CustomRecipe ? this.craftingRecipe.m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : this.craftingRecipe.m_8043_(this.f_58857_.m_9598_());
            this.patternResultSlots.m_6836_(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe == null || this.craftingRecipe == oldRecipe && ItemStack.m_150942_((ItemStack)resultItemStack, (ItemStack)oldResult))) {
                this.resetProgress();
            }
            this.oldCopyOfRecipe = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
                this.oldCopyOfRecipe.m_6836_(i, copyOfPatternSlots.m_8020_(i).m_41777_());
            }
        } else {
            this.recipeIdForSetRecipe = null;
            this.craftingRecipe = null;
            this.patternResultSlots.m_6836_(0, ItemStack.f_41583_);
            this.oldCopyOfRecipe = null;
            this.resetProgress();
        }
    }

    private void extractItems() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            if (patternSlotsForRecipe.m_8020_(i).m_41619_()) continue;
            patternItemStacks.add(patternSlotsForRecipe.m_8020_(i));
        }
        List<ItemStack> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (ItemStack itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack ret;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (ret = this.itemHandler.extractItem(i, itemStack.m_41613_(), false)).m_41619_()) continue;
                int amount = ret.m_41613_();
                if (amount == itemStack.m_41613_()) continue block1;
                itemStack.m_41774_(amount);
            }
        }
    }

    private void craftItem(CraftingContainer copyOfPatternSlots) {
        if (this.craftingRecipe == null) {
            this.resetProgress();
            return;
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack resultItemStack = this.craftingRecipe instanceof CustomRecipe ? this.craftingRecipe.m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : this.craftingRecipe.m_8043_(this.f_58857_.m_9598_());
        outputItemStacks.add(resultItemStack);
        for (ItemStack remainingItem : this.craftingRecipe.m_7457_((Container)copyOfPatternSlots)) {
            if (remainingItem.m_41619_()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block1: for (ItemStack itemStack : itemStacksInsert) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).m_255036_(testItemStack.m_41613_() + amount));
                itemStack.m_41764_(itemStack.m_41613_() - amount);
                if (itemStack.m_41619_()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT) {
            this.updateRecipe();
        }
        this.resetProgress();
    }

    private boolean canExtractItemsFromInput() {
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            if (patternSlotsForRecipe.m_8020_(i).m_41619_()) continue;
            patternItemStacks.add(patternSlotsForRecipe.m_8020_(i));
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                ItemStack itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                    if (testItemStack.m_41619_()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                    int amount = Math.min(itemStack.m_41613_(), testItemStack.m_41613_());
                    checkedIndices.add(j);
                    if (amount != itemStack.m_41613_()) {
                        itemStack.m_41774_(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots() {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack itemStack = resultItemStack = this.craftingRecipe instanceof CustomRecipe ? this.craftingRecipe.m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : this.craftingRecipe.m_8043_(this.f_58857_.m_9598_());
        if (!resultItemStack.m_41619_()) {
            outputItemStacks.add(resultItemStack);
        }
        for (ItemStack remainingItem : this.craftingRecipe.m_7457_((Container)copyOfPatternSlots)) {
            if (remainingItem.m_41619_()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            ItemStack itemStack2 = itemStacks.get(i);
            for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack2, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack2.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_());
                if (amount + testItemStack.m_41613_() == testItemStack.m_41741_()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack2.m_41613_()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack2.m_41774_(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack2.m_41613_() == itemStack2.m_41741_()) {
                checkedIndices.add(index);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(ItemStack itemStack) {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        ItemStack itemStack2 = resultItemStack = this.craftingRecipe instanceof CustomRecipe ? this.craftingRecipe.m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : this.craftingRecipe.m_8043_(this.f_58857_.m_9598_());
        if (ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)resultItemStack)) {
            return true;
        }
        for (ItemStack remainingItem : this.craftingRecipe.m_7457_((Container)copyOfPatternSlots)) {
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)remainingItem)) continue;
            return true;
        }
        return false;
    }

    private boolean isInput(ItemStack itemStack) {
        if (this.craftingRecipe == null) {
            return false;
        }
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            if (!(this.ignoreNBT ? ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)this.patternSlots.m_8020_(i)) : ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.patternSlots.m_8020_(i)))) continue;
            return true;
        }
        return false;
    }

    private SimpleContainer replaceCraftingPatternWithCurrentNBTItems(SimpleContainer container) {
        SimpleContainer copyOfContainer = new SimpleContainer(container.m_6643_());
        for (int i = 0; i < container.m_6643_(); ++i) {
            copyOfContainer.m_6836_(i, container.m_8020_(i).m_41777_());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.m_6643_(); ++i) {
            int usedCount;
            ItemStack testItemStack;
            int j;
            ItemStack itemStack = copyOfContainer.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).m_41777_();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.m_41764_(testItemStack.m_41613_() - usedCount);
                if (testItemStack.m_41613_() <= 0 || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).m_41777_();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.m_41764_(testItemStack.m_41613_() - usedCount);
                if (testItemStack.m_41613_() <= 0 || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.m_6836_(i, testItemStack.m_255036_(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<CraftingRecipe> getRecipesFor(CraftingContainer patternSlots, Level level) {
        return level.m_7465_().m_44013_(RecipeType.f_44107_).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.m_6423_())).filter(recipe -> recipe.m_5818_((Container)patternSlots, level)).sorted(Comparator.comparing(recipe -> recipe.m_8043_(level.m_9598_()).m_41778_())).toList();
    }

    private Optional<Pair<ResourceLocation, CraftingRecipe>> getRecipeFor(CraftingContainer patternSlots, Level level, ResourceLocation recipeId) {
        List<CraftingRecipe> recipes = this.getRecipesFor(patternSlots, level);
        Optional<CraftingRecipe> recipe = recipes.stream().filter(r -> r.m_6423_().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.m_6423_(), (Object)r));
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.updateRecipe();
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
            }
        }
    }
}

