/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.AlloyFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ALLOY_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private int progress;
    private int maxProgress;
    private int litDuration;
    private int maxLitDuration;
    private final Predicate<Integer> canOutput = i -> {
        if (i == 3) {
            ItemStack item = this.itemHandler.getStackInSlot(i.intValue());
            return ForgeHooks.getBurnTime((ItemStack)item, null) <= 0;
        }
        return i > 3 && i < 6;
    };
    private final LazyOptional<IItemHandler> itemHandlerSidedTopBottom = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 3, this.canOutput));
    private final LazyOptional<IItemHandler> itemHandlerSidedFront = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, this.canOutput));
    private final LazyOptional<IItemHandler> itemHandlerSidedBack = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, this.canOutput));
    private final LazyOptional<IItemHandler> itemHandlerSidedLeft = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, this.canOutput));
    private final LazyOptional<IItemHandler> itemHandlerSidedRight = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, this.canOutput));

    public AlloyFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.ALLOY_FURNACE_ENTITY.get(), blockPos, blockState, "alloy_furnace", 6);
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AlloyFurnaceBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AlloyFurnaceBlockEntity.this.f_58857_ == null || AlloyFurnaceBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)AlloyFurnaceRecipe.Type.INSTANCE).stream().map(AlloyFurnaceRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (ForgeHooks.getBurnTime((ItemStack)stack, null) > 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AlloyFurnaceBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        AlloyFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.litDuration, index - 4);
                    case 6, 7 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.maxLitDuration, index - 6);
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AlloyFurnaceBlockEntity.this.progress = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AlloyFurnaceBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: {
                        AlloyFurnaceBlockEntity.this.litDuration = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.litDuration, (short)value, index - 4);
                        break;
                    }
                    case 6: 
                    case 7: {
                        AlloyFurnaceBlockEntity.this.maxLitDuration = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.maxLitDuration, (short)value, index - 6);
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new AlloyFurnaceMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)AssemblingMachineBlock.FACING);
            if (facing == side) {
                return this.itemHandlerSidedFront.cast();
            }
            if (facing.m_122424_() == side) {
                return this.itemHandlerSidedBack.cast();
            }
            if (facing.m_122427_() == side) {
                return this.itemHandlerSidedLeft.cast();
            }
            if (facing.m_122428_() == side) {
                return this.itemHandlerSidedRight.cast();
            }
            return this.itemHandlerSidedTopBottom.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.max_progress", (Tag)IntTag.m_128679_((int)this.maxProgress));
        nbt.m_128365_("recipe.lit_duration", (Tag)IntTag.m_128679_((int)this.litDuration));
        nbt.m_128365_("recipe.max_lit_duration", (Tag)IntTag.m_128679_((int)this.maxLitDuration));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("recipe.progress");
        this.maxProgress = nbt.m_128451_("recipe.max_progress");
        this.litDuration = nbt.m_128451_("recipe.lit_duration");
        this.maxLitDuration = nbt.m_128451_("recipe.max_lit_duration");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AlloyFurnaceBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean hasNotEnoughFuel = false;
        if (blockEntity.litDuration > 0) {
            --blockEntity.litDuration;
            if (blockEntity.litDuration <= 0) {
                blockEntity.maxLitDuration = 0;
                hasNotEnoughFuel = true;
            }
            AlloyFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (blockEntity.hasRecipe()) {
            Optional<AlloyFurnaceRecipe> recipe = blockEntity.getCurrentRecipe();
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.litDuration <= 0) {
                ItemStack item = blockEntity.itemHandler.getStackInSlot(3);
                blockEntity.litDuration = blockEntity.maxLitDuration = ForgeHooks.getBurnTime((ItemStack)item, null);
                if (blockEntity.maxLitDuration > 0) {
                    blockEntity.onHasEnoughFuel();
                    hasNotEnoughFuel = false;
                    if (item.hasCraftingRemainingItem()) {
                        blockEntity.itemHandler.setStackInSlot(3, item.getCraftingRemainingItem());
                    } else {
                        blockEntity.itemHandler.extractItem(3, 1, false);
                    }
                }
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)((float)recipe.get().getTicks() * RECIPE_DURATION_MULTIPLIER));
            }
            if (blockEntity.litDuration > 0) {
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                    if (hasNotEnoughFuel) {
                        blockEntity.onHasNotEnoughFuel();
                    }
                    blockEntity.resetProgress();
                    AlloyFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem(recipe.get());
                }
                AlloyFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.progress = Math.max(blockEntity.progress - 2, 0);
                hasNotEnoughFuel = true;
                AlloyFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            AlloyFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (hasNotEnoughFuel) {
            blockEntity.onHasNotEnoughFuel();
        }
    }

    private void onHasEnoughFuel() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void onHasNotEnoughFuel() {
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private Optional<AlloyFurnaceRecipe> getRecipeFor(Container inventory) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)EPRecipes.ALLOY_FURNACE_TYPE.get(), inventory, this.f_58857_);
    }

    private Optional<AlloyFurnaceRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory);
    }

    private boolean hasRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional<AlloyFurnaceRecipe> recipe = this.getRecipeFor((Container)inventory);
        return recipe.isPresent() && this.canCraftRecipe(inventory, recipe.get());
    }

    protected void craftItem(AlloyFurnaceRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = recipe.getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).m_41619_();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input().test(item) || item.m_41613_() < input.count()) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        ItemStack[] outputs = recipe.generateOutputs(this.f_58857_.f_46441_);
        this.itemHandler.setStackInSlot(4, outputs[0].m_255036_(this.itemHandler.getStackInSlot(4).m_41613_() + outputs[0].m_41613_()));
        if (!outputs[1].m_41619_()) {
            this.itemHandler.setStackInSlot(5, outputs[1].m_255036_(this.itemHandler.getStackInSlot(5).m_41613_() + outputs[1].m_41613_()));
        }
        this.resetProgress();
    }

    private boolean canCraftRecipe(SimpleContainer inventory, AlloyFurnaceRecipe recipe) {
        ItemStack[] maxOutputs = recipe.getMaxOutputCounts();
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, maxOutputs[0]) && (maxOutputs[1].m_41619_() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 5, maxOutputs[1]));
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
    }
}

