/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SimpleRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EPFluids;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.CrusherRecipe;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.screen.AdvancedCrusherMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedCrusherBlockEntity
extends SimpleRecipeFluidMachineBlockEntity<EnergizedPowerFluidStorage, CrusherRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_ADVANCED_CRUSHER_TANK_CAPACITY.getValue();
    public static final int WATER_CONSUMPTION_PER_RECIPE = ModConfigs.COMMON_ADVANCED_CRUSHER_WATER_USAGE_PER_RECIPE.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));

    public AdvancedCrusherBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EPBlockEntities.ADVANCED_CRUSHER_ENTITY.get(), blockPos, blockState, "advanced_crusher", AdvancedCrusherMenu::new, 2, (RecipeType)EPRecipes.CRUSHER_TYPE.get(), (int)ModConfigs.COMMON_ADVANCED_CRUSHER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_ADVANCED_CRUSHER_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_CRUSHER_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_ADVANCED_CRUSHER_ENERGY_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedCrusherBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (AdvancedCrusherBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(AdvancedCrusherBlockEntity.this.f_58857_, CrusherRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedCrusherBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        AdvancedCrusherBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                AdvancedCrusherBlockEntity.this.m_6596_();
                AdvancedCrusherBlockEntity.this.syncFluidToPlayers(32);
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1));
                    case 1 -> stack.isFluidEqual(new FluidStack((Fluid)EPFluids.DIRTY_WATER.get(), 1));
                    default -> false;
                };
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(CrusherRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)Fluids.f_76193_, WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        ((EnergizedPowerFluidStorage)this.fluidStorage).fill(new FluidStack((Fluid)EPFluids.DIRTY_WATER.get(), WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, CrusherRecipe recipe) {
        return this.f_58857_ != null && ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(0).getAmount() >= WATER_CONSUMPTION_PER_RECIPE && ((EnergizedPowerFluidStorage)this.fluidStorage).getCapacity(1) - ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(1).getAmount() >= WATER_CONSUMPTION_PER_RECIPE && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, recipe.m_8043_(this.f_58857_.m_9598_()));
    }
}

