/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import java.util.function.ToIntFunction;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.LightningGeneratorBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LightningGeneratorBlock
extends BaseEntityBlock {
    public static final int ENERGY_PER_LIGHTNING_STRIKE = ModConfigs.COMMON_LIGHTNING_GENERATOR_CAPACITY.getValue();
    public static final BooleanProperty HIT_BY_LIGHTNING_BOLT = BooleanProperty.m_61465_((String)"hit_by_lightning_bolt");
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.m_61143_((Property)HIT_BY_LIGHTNING_BOLT) != false ? 15 : 0;
    private static final int ACTIVATION_TICKS = 8;

    public LightningGeneratorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new LightningGeneratorBlockEntity(blockPos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{HIT_BY_LIGHTNING_BOLT});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand handItem, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof LightningGeneratorBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((LightningGeneratorBlockEntity)blockEntity), (BlockPos)blockPos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6861_(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.m_5776_()) {
            return;
        }
        if (!selfPos.m_7494_().equals((Object)fromPos) || !(fromBlock instanceof LightningRodBlock)) {
            return;
        }
        BlockState fromState = level.m_8055_(fromPos);
        if (!(fromState.m_61138_((Property)LightningRodBlock.f_153703_) && ((Boolean)fromState.m_61143_((Property)LightningRodBlock.f_153703_)).booleanValue() && fromState.m_61138_((Property)LightningRodBlock.f_153703_) && fromState.m_61143_((Property)DirectionalBlock.f_52588_) == Direction.UP)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(selfPos);
        if (!(blockEntity instanceof LightningGeneratorBlockEntity)) {
            return;
        }
        level.m_7731_(selfPos, (BlockState)selfState.m_61124_((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.TRUE), 3);
        level.m_186460_(selfPos, (Block)this, 8);
        ((LightningGeneratorBlockEntity)blockEntity).onLightningStrike();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return LightningGeneratorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EPBlockEntities.LIGHTING_GENERATOR_ENTITY.get()), LightningGeneratorBlockEntity::tick);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)HIT_BY_LIGHTNING_BOLT)).booleanValue()) {
            ParticleUtils.m_216313_((Level)level, (BlockPos)blockPos, (ParticleOptions)ParticleTypes.f_175830_, (IntProvider)UniformInt.m_146622_((int)2, (int)5));
        }
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.lightning_generator.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_PER_LIGHTNING_STRIKE)}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.lightning_generator.txt.shift.2").m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

