/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EPBlockStateProperties {
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_UP = EnumProperty.m_61587_((String)"up", PipeConnection.class);
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_DOWN = EnumProperty.m_61587_((String)"down", PipeConnection.class);
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_NORTH = EnumProperty.m_61587_((String)"north", PipeConnection.class);
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_EAST = EnumProperty.m_61587_((String)"east", PipeConnection.class);
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_SOUTH = EnumProperty.m_61587_((String)"south", PipeConnection.class);
    public static final EnumProperty<PipeConnection> PIPE_CONNECTION_WEST = EnumProperty.m_61587_((String)"west", PipeConnection.class);
    public static final EnumProperty<ConveyorBeltDirection> CONVEYOR_BELT_FACING = EnumProperty.m_61587_((String)"facing", ConveyorBeltDirection.class);

    private EPBlockStateProperties() {
    }

    public static enum PipeConnection implements StringRepresentable
    {
        NOT_CONNECTED,
        CONNECTED,
        EXTRACT;


        public boolean isConnected() {
            return this != NOT_CONNECTED;
        }

        public boolean isInsert() {
            return this == CONNECTED;
        }

        public boolean isExtract() {
            return this == EXTRACT;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }

        public String getTranslationKey() {
            return "block_state.energizedpower.pipe_connection." + this.m_7912_();
        }
    }

    public static enum ConveyorBeltDirection implements StringRepresentable
    {
        NORTH_SOUTH(Direction.SOUTH),
        SOUTH_NORTH(Direction.NORTH),
        WEST_EAST(Direction.EAST),
        EAST_WEST(Direction.WEST),
        ASCENDING_NORTH_SOUTH(Direction.SOUTH),
        ASCENDING_SOUTH_NORTH(Direction.NORTH),
        ASCENDING_WEST_EAST(Direction.EAST),
        ASCENDING_EAST_WEST(Direction.WEST),
        DESCENDING_NORTH_SOUTH(Direction.SOUTH),
        DESCENDING_SOUTH_NORTH(Direction.NORTH),
        DESCENDING_WEST_EAST(Direction.EAST),
        DESCENDING_EAST_WEST(Direction.WEST);

        private final Direction direction;

        public static ConveyorBeltDirection of(@NotNull Direction direction, @Nullable Boolean slope) {
            return switch (direction) {
                case Direction.SOUTH -> {
                    if (slope == null) {
                        yield NORTH_SOUTH;
                    }
                    if (slope.booleanValue()) {
                        yield ASCENDING_NORTH_SOUTH;
                    }
                    yield DESCENDING_NORTH_SOUTH;
                }
                case Direction.NORTH -> {
                    if (slope == null) {
                        yield SOUTH_NORTH;
                    }
                    if (slope.booleanValue()) {
                        yield ASCENDING_SOUTH_NORTH;
                    }
                    yield DESCENDING_SOUTH_NORTH;
                }
                case Direction.EAST -> {
                    if (slope == null) {
                        yield WEST_EAST;
                    }
                    if (slope.booleanValue()) {
                        yield ASCENDING_WEST_EAST;
                    }
                    yield DESCENDING_WEST_EAST;
                }
                case Direction.WEST -> {
                    if (slope == null) {
                        yield EAST_WEST;
                    }
                    if (slope.booleanValue()) {
                        yield ASCENDING_EAST_WEST;
                    }
                    yield DESCENDING_EAST_WEST;
                }
                default -> throw new IllegalArgumentException("Direction must be one of NORTH, SOUTH, WEST, or EAST");
            };
        }

        private ConveyorBeltDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public boolean isAscending() {
            return this == ASCENDING_NORTH_SOUTH || this == ASCENDING_SOUTH_NORTH || this == ASCENDING_WEST_EAST || this == ASCENDING_EAST_WEST;
        }

        public boolean isDescending() {
            return this == DESCENDING_NORTH_SOUTH || this == DESCENDING_SOUTH_NORTH || this == DESCENDING_WEST_EAST || this == DESCENDING_EAST_WEST;
        }

        @Nullable
        public Boolean getSlope() {
            if (this.isAscending()) {
                return true;
            }
            if (this.isDescending()) {
                return false;
            }
            return null;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }

        public String getTranslationKey() {
            return "block_state.energizedpower.conveyor_belt_direction." + this.m_7912_();
        }
    }
}

