/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.Embers;
import com.rekindled.embers.api.event.InfoGogglesEvent;
import com.rekindled.embers.api.tile.IProxyable;
import com.rekindled.embers.datagen.EmbersBlockTags;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Misc {
    public static final double LOG_E = Math.log10(Math.exp(1.0));
    public static Random random = new Random();
    public static Direction[] horizontals = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final List<BiPredicate<Player, InteractionHand>> IS_HOLDING_HAMMER = new ArrayList<BiPredicate<Player, InteractionHand>>();
    public static final List<Function<Player, Pair<BlockPos, Direction>>> GET_HAMMER_TARGET = new ArrayList<Function<Player, Pair<BlockPos, Direction>>>();
    public static final List<Predicate<Player>> IS_WEARING_LENS = new ArrayList<Predicate<Player>>();
    public static final List<Function<ItemStack, Double>> GET_EMBER_RESONANCE = new ArrayList<Function<ItemStack, Double>>();
    public static ConcurrentHashMap<ResourceLocation, Item> tagItems = new ConcurrentHashMap();
    public static String[] lightstyle = new String[]{"m", "mmnmmommommnonmmonqnmmo", "abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba", "mmmmmaaaaammmmmaaaaaabcdefgabcdefg", "mamamamamama", "jklmnopqrstuvwxyzyxwvutsrqponmlkj", "nmonqnmomnmomomno", "mmmaaaabcdefgmmmmaaaammmaamm", "mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa", "aaaaaaaazzzzzzzz", "mmamammmmammamamaaamammma", "abcdefghijklmnopqrrqponmlkjihgfedcba", "a"};

    public static void spawnInventoryInWorld(Level world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.f_46443_) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).m_41619_()) continue;
                world.m_7967_((Entity)new ItemEntity(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }

    public static boolean isHoldingHammer(Player player, InteractionHand hand) {
        for (BiPredicate<Player, InteractionHand> predicate : IS_HOLDING_HAMMER) {
            if (!predicate.test(player, hand)) continue;
            return true;
        }
        return false;
    }

    public static Pair<BlockPos, Direction> getHammerTarget(Player player) {
        for (Function<Player, Pair<BlockPos, Direction>> func : GET_HAMMER_TARGET) {
            Pair<BlockPos, Direction> target = func.apply(player);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public static boolean isWearingLens(Player player) {
        boolean wearingLens = false;
        for (Predicate<Player> predicate : IS_WEARING_LENS) {
            if (!predicate.test(player)) continue;
            wearingLens = true;
        }
        InfoGogglesEvent event = new InfoGogglesEvent(player, wearingLens);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.shouldDisplay();
    }

    public static double getEmberResonance(ItemStack stack) {
        for (Function<ItemStack, Double> func : GET_EMBER_RESONANCE) {
            double resonance = func.apply(stack);
            if (!(resonance >= 1.0)) continue;
            return resonance;
        }
        return 1.0;
    }

    public static Direction readNullableFacing(int index) {
        return index > 0 ? Direction.m_122376_((int)index) : null;
    }

    public static int writeNullableFacing(Direction facing) {
        return facing != null ? facing.m_122411_() : -1;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    public static JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", Objects.requireNonNull(((ResourceKey)ForgeRegistries.FLUIDS.getResourceKey((Object)stack.getFluid()).get()).m_135782_()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static boolean isGaseousFluid(FluidStack resource) {
        return resource != null && resource.getFluid().getFluidType().getDensity() <= 0;
    }

    public static double getDiminishedPower(double power, double softcap, double slope) {
        if (power > softcap) {
            return softcap * slope + Math.log10(power - softcap + LOG_E / slope) - Math.log10(LOG_E / slope);
        }
        return power * slope;
    }

    public static void drawComponents(Font fontRenderer, GuiGraphics guiGraphics, int x, int y, Component ... components) {
        for (Component component : components) {
            guiGraphics.m_280430_(fontRenderer, component, x, y, 0xFFFFFF);
            Objects.requireNonNull(fontRenderer);
            y += 9 + 2;
        }
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static int intColor(int a, int r, int g, int b) {
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static Vector3f colorFromInt(int color) {
        return new Vector3f((float)((0xFF0000 & color) >> 16) / 255.0f, (float)((0xFF00 & color) >> 8) / 255.0f, (float)(0xFF & color) / 255.0f);
    }

    public static Color lerpColor(Color color1, Color color2, double scale) {
        return new Color(Misc.lerp(color1.getRed(), color2.getRed(), scale), Misc.lerp(color1.getGreen(), color2.getGreen(), scale), Misc.lerp(color1.getBlue(), color2.getBlue(), scale), Misc.lerp(color1.getAlpha(), color2.getAlpha(), scale));
    }

    public static int lerp(int a, int b, double scale) {
        return (int)((double)a * (1.0 - scale) + (double)b * scale);
    }

    public static <C extends Container, T extends Recipe<C>> T getRecipe(T cache, RecipeType<?> type, C container, Level level) {
        if (cache != null && cache.m_5818_(container, level)) {
            return cache;
        }
        List recipes = level.m_7465_().m_44056_(type, container, level);
        if (recipes.isEmpty()) {
            return null;
        }
        return (T)((Recipe)recipes.get(0));
    }

    public static Item getTaggedItem(TagKey<Item> tag) {
        if (tagItems.containsKey(tag.f_203868_())) {
            return tagItems.get(tag.f_203868_());
        }
        Item output = Items.f_41852_;
        int index = Integer.MAX_VALUE;
        List preferences = (List)ConfigManager.TAG_PREFERENCES.get();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tag)) {
            for (int i = 0; i < preferences.size(); ++i) {
                if (i >= index || !((String)preferences.get(i)).equals(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)holder.get())).m_135827_())) continue;
                output = (Item)holder.get();
                index = i;
            }
            if (output != Items.f_41852_) continue;
            output = (Item)holder.get();
        }
        if (output != Items.f_41852_) {
            tagItems.put(tag.f_203868_(), output);
        }
        return output;
    }

    public static ItemStack getPreferredItem(ItemStack[] items) {
        ItemStack output = ItemStack.f_41583_;
        int index = Integer.MAX_VALUE;
        List itemPreferences = (List)ConfigManager.ITEM_PREFERENCES.get();
        List preferences = (List)ConfigManager.TAG_PREFERENCES.get();
        for (ItemStack item : items) {
            int i;
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
            for (i = 0; i < itemPreferences.size(); ++i) {
                if (!key.toString().equals(itemPreferences.get(i))) continue;
                return item;
            }
            for (i = 0; i < preferences.size(); ++i) {
                if (i >= index || !((String)preferences.get(i)).equals(key.m_135827_())) continue;
                output = item;
                index = i;
            }
            if (!output.m_41619_()) continue;
            output = item;
        }
        return output;
    }

    public static List<EntityHitResult> getEntityHitResults(Level level, Entity projectile, Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> pFilter, float pInflationAmount) {
        ArrayList<EntityHitResult> entities = new ArrayList<EntityHitResult>();
        double motionX = endVec.f_82479_ - startVec.f_82479_;
        double motionY = endVec.f_82480_ - startVec.f_82480_;
        double motionZ = endVec.f_82481_ - startVec.f_82481_;
        for (Entity entity : level.m_6249_(projectile, boundingBox.m_82363_(motionX, motionY, motionZ).m_82400_(1.0), pFilter)) {
            AABB aabb;
            Optional optional;
            if (entity == shooter || !(optional = (aabb = entity.m_20191_().m_82400_((double)pInflationAmount)).m_82371_(startVec, endVec)).isPresent()) continue;
            entities.add(new EntityHitResult(entity, (Vec3)optional.get()));
        }
        entities.sort((o1, o2) -> Double.compare(startVec.m_82557_(o1.m_82450_()), startVec.m_82557_(o2.m_82450_())));
        return entities;
    }

    public static EquipmentSlot handToSlot(InteractionHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return EquipmentSlot.MAINHAND;
            }
            case OFF_HAND: {
                return EquipmentSlot.OFFHAND;
            }
        }
        return null;
    }

    public static IItemHandler makeRestrictedItemHandler(final IItemHandler handler, final boolean input, final boolean output) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!input) {
                    return stack;
                }
                return handler.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!output) {
                    return ItemStack.f_41583_;
                }
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return input && handler.isItemValid(slot, stack);
            }
        };
    }

    public static IFluidHandler makeRestrictedFluidHandler(final IFluidHandler handler, final boolean input, final boolean output) {
        return new IFluidHandler(){

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!input) {
                    return 0;
                }
                return handler.fill(resource, action);
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!output) {
                    return null;
                }
                return handler.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (!output) {
                    return null;
                }
                return handler.drain(maxDrain, action);
            }

            public int getTanks() {
                return handler.getTanks();
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return handler.getFluidInTank(tank);
            }

            public int getTankCapacity(int tank) {
                return handler.getTankCapacity(tank);
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return input && handler.isFluidValid(tank, stack);
            }
        };
    }

    public static Direction.Axis getOtherAxis(Direction.Axis axis1, Direction.Axis axis2) {
        switch (axis1) {
            default: {
                return axis2;
            }
            case X: {
                switch (axis2) {
                    case Y: {
                        return Direction.Axis.Z;
                    }
                    case Z: {
                        return Direction.Axis.Y;
                    }
                }
                return axis2;
            }
            case Y: {
                switch (axis2) {
                    case X: {
                        return Direction.Axis.Z;
                    }
                    case Z: {
                        return Direction.Axis.X;
                    }
                }
                return axis2;
            }
            case Z: 
        }
        switch (axis2) {
            case X: {
                return Direction.Axis.Y;
            }
            case Y: {
                return Direction.Axis.X;
            }
        }
        return axis2;
    }

    public static float getLightBrightness(int style, int ticks) {
        String table = lightstyle[style];
        return (float)(table.charAt(ticks / 2 % table.length()) - 97) / 25.0f;
    }

    public static Ingredient getRepairIngredient(Item item) {
        Ingredient ingredient;
        if (item instanceof TieredItem) {
            TieredItem tool = (TieredItem)item;
            try {
                ingredient = tool.m_43314_().m_6282_();
                if (ingredient != null) {
                    return ingredient;
                }
                Embers.LOGGER.error("Item: \"" + ForgeRegistries.ITEMS.getKey((Object)item) + "\" has no proper repair ingredient, this is a bug and should be reported to " + ForgeRegistries.ITEMS.getKey((Object)item).m_135827_());
            }
            catch (Exception e) {
                Embers.LOGGER.error("Item: \"" + ForgeRegistries.ITEMS.getKey((Object)item) + "\" has no proper tool tier, this is a bug and should be reported to " + ForgeRegistries.ITEMS.getKey((Object)item).m_135827_(), (Throwable)e);
            }
        }
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            try {
                ingredient = armor.m_40401_().m_6230_();
                if (ingredient != null) {
                    return ingredient;
                }
                Embers.LOGGER.error("Item: \"" + ForgeRegistries.ITEMS.getKey((Object)item) + "\" of material: \"" + armor.m_40401_().m_6082_() + "\" has no proper repair ingredient, this is a bug and should be reported to " + ForgeRegistries.ITEMS.getKey((Object)item).m_135827_());
            }
            catch (Exception e) {
                Embers.LOGGER.error("Item: \"" + ForgeRegistries.ITEMS.getKey((Object)item) + "\" has no proper armor material, this is a bug and should be reported to " + ForgeRegistries.ITEMS.getKey((Object)item).m_135827_(), (Throwable)e);
            }
        }
        return Ingredient.f_43901_;
    }

    public static InteractionResult useItemOnInventory(IItemHandlerModifiable inventory, Level level, Player player, InteractionHand hand) {
        ItemStack leftover;
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_() && !ItemStack.m_41728_((ItemStack)heldItem, (ItemStack)(leftover = inventory.insertItem(0, heldItem, false)))) {
            player.m_21008_(hand, leftover);
            return InteractionResult.SUCCESS;
        }
        if (!inventory.getStackInSlot(0).m_41619_()) {
            if (!level.f_46443_) {
                Misc.giveItemToPlayer(inventory.getStackInSlot(0), player, player.m_150109_().f_35977_);
                inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void giveItemToPlayer(ItemStack stack, Player player) {
        Misc.giveItemToPlayer(stack, player, -1);
    }

    public static void giveItemToPlayer(ItemStack stack, Player player, int slot) {
        boolean success = false;
        if (slot != -1 && ((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41619_()) {
            boolean bl = success = player.m_150109_().m_36040_(slot, stack) && stack.m_41619_();
        }
        if (!success) {
            boolean bl = success = player.m_150109_().m_36054_(stack) && stack.m_41619_();
        }
        if (success) {
            stack.m_41764_(1);
            ItemEntity itementity1 = player.m_36176_(stack, false);
            if (itementity1 != null) {
                itementity1.m_32065_();
            }
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36096_.m_38946_();
        } else {
            ItemEntity itementity = player.m_36176_(stack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_266426_(player.m_20148_());
            }
        }
    }

    public static void sendToTrackingPlayers(Level level, BlockPos pos, Packet<?> packet) {
        if (level instanceof ServerLevel && packet != null) {
            for (ServerPlayer serverplayer : ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(new ChunkPos(pos), false)) {
                serverplayer.f_8906_.m_9829_(packet);
            }
        }
    }

    public static boolean isSideProxyable(BlockState state, BlockEntity tile, Direction face) {
        IProxyable proxyable;
        return state.m_204336_(EmbersBlockTags.MECH_CORE_PROXYABLE) || state.m_204336_(EmbersBlockTags.MECH_CORE_PROXYABLE_BOTTOM) && face == Direction.DOWN || state.m_204336_(EmbersBlockTags.MECH_CORE_PROXYABLE_TOP) && face == Direction.UP || tile instanceof IProxyable && (proxyable = (IProxyable)tile).isSideProxyable(face);
    }
}

