/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.research.capability;

import com.rekindled.embers.research.capability.DefaultResearchCapability;
import com.rekindled.embers.research.capability.IResearchCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ResearchCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private IResearchCapability capability;
    public LazyOptional<IResearchCapability> holder = LazyOptional.of(() -> this.capability);
    public static final Capability<IResearchCapability> researchCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<IResearchCapability>(){});

    public ResearchCapabilityProvider() {
        this.capability = new DefaultResearchCapability();
        this.holder = LazyOptional.of(() -> this.capability);
    }

    public ResearchCapabilityProvider(IResearchCapability capability) {
        this.capability = capability;
        this.holder = LazyOptional.of(() -> this.capability);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (researchCapability != null && capability == researchCapability) {
            return researchCapability.orEmpty(capability, this.holder);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.capability.writeToNBT(compound);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.capability.readFromNBT(compound);
    }
}

