/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.render;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FluidCuboid {
    public static final Map<Direction, FluidFace> DEFAULT_FACES = new EnumMap<Direction, FluidFace>(Direction.class);
    public static final Map<Direction, FluidFace> FLOWING_DOWN_FACES = new EnumMap<Direction, FluidFace>(Direction.class);
    private final Vector3f from;
    private final Vector3f to;
    private final Map<Direction, FluidFace> faces;
    @Nullable
    private Vector3f fromScaled;
    @Nullable
    private Vector3f toScaled;

    public FluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidFace> faces) {
        this.from = from;
        this.to = to;
        this.faces = faces;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Map<Direction, FluidFace> getFaces() {
        return this.faces;
    }

    @Nullable
    public FluidFace getFace(Direction face) {
        return this.faces.get(face);
    }

    public Vector3f getFromScaled() {
        if (this.fromScaled == null) {
            this.fromScaled = new Vector3f((Vector3fc)this.from);
            this.fromScaled.mul(0.0625f);
        }
        return this.fromScaled;
    }

    public Vector3f getToScaled() {
        if (this.toScaled == null) {
            this.toScaled = new Vector3f((Vector3fc)this.to);
            this.toScaled.mul(0.0625f);
        }
        return this.toScaled;
    }

    public static FluidCuboid fromJson(JsonObject json) {
        Vector3f from = FluidCuboid.arrayToVector(json, "from");
        Vector3f to = FluidCuboid.arrayToVector(json, "to");
        Map<Direction, FluidFace> faces = FluidCuboid.getFaces(json);
        return new FluidCuboid(from, to, faces);
    }

    public static List<FluidCuboid> listFromJson(JsonObject parent, String key) {
        JsonElement json = parent.get(key);
        if (json.isJsonObject()) {
            return Collections.singletonList(FluidCuboid.fromJson(json.getAsJsonObject()));
        }
        if (json.isJsonArray()) {
            return FluidCuboid.parseList(json.getAsJsonArray(), key, FluidCuboid::fromJson);
        }
        throw new JsonSyntaxException("Invalid fluid '" + key + "', must be an array or an object");
    }

    protected static Map<Direction, FluidFace> getFaces(JsonObject json) {
        if (!json.has("faces")) {
            return DEFAULT_FACES;
        }
        EnumMap<Direction, FluidFace> faces = new EnumMap<Direction, FluidFace>(Direction.class);
        JsonObject object = GsonHelper.m_13930_((JsonObject)json, (String)"faces");
        for (Map.Entry entry : object.entrySet()) {
            String name = (String)entry.getKey();
            Direction dir = Direction.m_122402_((String)name);
            if (dir != null) {
                JsonObject face = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)name);
                boolean flowing = GsonHelper.m_13855_((JsonObject)face, (String)"flowing", (boolean)false);
                int rotation = FluidCuboid.getRotation(face, "rotation");
                faces.put(dir, new FluidFace(flowing, rotation));
                continue;
            }
            throw new JsonSyntaxException("Unknown face '" + name + "'");
        }
        return faces;
    }

    public static int getRotation(JsonObject json, String key) {
        int i = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)0);
        if (i >= 0 && i % 90 == 0 && i / 90 <= 3) {
            return i;
        }
        throw new JsonParseException("Invalid '" + key + "' " + i + " found, only 0/90/180/270 allowed");
    }

    public static Vector3f arrayToVector(JsonObject json, String name) {
        return FluidCuboid.arrayToObject(json, name, 3, arr -> new Vector3f(arr[0], arr[1], arr[2]));
    }

    public static <T> T arrayToObject(JsonObject json, String name, int size, Function<float[], T> mapper) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (array.size() != size) {
            throw new JsonParseException("Expected " + size + " " + name + " values, found: " + array.size());
        }
        float[] vec = new float[size];
        for (int i = 0; i < size; ++i) {
            vec[i] = GsonHelper.m_13888_((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return mapper.apply(vec);
    }

    public static <T> List<T> parseList(JsonArray array, String name, BiFunction<JsonElement, String, T> mapper) {
        if (array.size() == 0) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.apply(array.get(i), name + "[" + i + "]"));
        }
        return builder.build();
    }

    public static <T> List<T> parseList(JsonArray array, String name, Function<JsonObject, T> mapper) {
        return FluidCuboid.parseList(array, name, (JsonElement element, String s) -> mapper.apply(GsonHelper.m_13918_((JsonElement)element, (String)s)));
    }

    static {
        for (Direction direction : Direction.values()) {
            DEFAULT_FACES.put(direction, FluidFace.NORMAL);
            if (direction.m_122434_() == Direction.Axis.Y) {
                FLOWING_DOWN_FACES.put(direction, FluidFace.NORMAL);
                continue;
            }
            FLOWING_DOWN_FACES.put(direction, FluidFace.DOWN);
        }
    }

    public record FluidFace(boolean isFlowing, int rotation) {
        public static final FluidFace NORMAL = new FluidFace(false, 0);
        public static final FluidFace DOWN = new FluidFace(true, 0);
    }
}

