/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.render;

import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BakedPipeModel
implements BakedModel {
    private final BakedModel centerModel;
    private BakedModel[] connectionModel;
    private BakedModel[] endModel;
    public static final List<BakedQuad> EMPTY = new ArrayList<BakedQuad>();
    public final List<BakedQuad>[] QUAD_CACHE = new List[729];

    public BakedPipeModel(BakedModel centerModel, BakedModel[] connectionModel, BakedModel[] endModel) {
        this.centerModel = centerModel;
        this.connectionModel = connectionModel;
        this.endModel = endModel;
    }

    public static int getCacheIndex(int[] data) {
        return ((((data[0] * 3 + data[1]) * 3 + data[2]) * 3 + data[3]) * 3 + data[4]) * 3 + data[5];
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        if (side != null) {
            return EMPTY;
        }
        int[] sides = (int[])data.get(PipeBlockEntityBase.DATA_TYPE);
        if (sides != null) {
            List<BakedQuad> quads = this.QUAD_CACHE[BakedPipeModel.getCacheIndex(sides)];
            if (quads != null) {
                return quads;
            }
            quads = new ArrayList<BakedQuad>();
            quads.addAll(this.centerModel.getQuads(state, side, rand, data, renderType));
            if (quads.isEmpty()) {
                return quads;
            }
            for (int i = 0; i < sides.length; ++i) {
                if (sides[i] == 1) {
                    quads.addAll(this.connectionModel[i].getQuads(state, side, rand, data, renderType));
                    continue;
                }
                if (sides[i] != 2) continue;
                quads.addAll(this.endModel[i].getQuads(state, side, rand, data, renderType));
            }
            if (!quads.isEmpty()) {
                this.QUAD_CACHE[BakedPipeModel.getCacheIndex((int[])sides)] = new ArrayList<BakedQuad>(quads);
            }
            return quads;
        }
        return this.centerModel.getQuads(state, side, rand, data, renderType);
    }

    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        return this.centerModel.m_213637_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.centerModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.centerModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.centerModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.centerModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.centerModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

