/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EmberActivationRecipe
implements IEmberActivationRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final int ember;

    public EmberActivationRecipe(ResourceLocation id, Ingredient ingredient, int ember) {
        this.id = id;
        this.ingredient = ingredient;
        this.ember = ember;
    }

    public boolean m_5818_(Container context, Level pLevel) {
        for (int i = 0; i < context.m_6643_(); ++i) {
            if (!this.ingredient.test(context.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOutput(Container context) {
        return this.ember;
    }

    @Override
    public int process(Container context) {
        for (int i = 0; i < context.m_6643_(); ++i) {
            if (!this.ingredient.test(context.m_8020_(i))) continue;
            context.m_7407_(i, 1);
            break;
        }
        return this.ember;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public Ingredient getDisplayInput() {
        return this.ingredient;
    }

    @Override
    public int getDisplayOutput() {
        return this.ember;
    }

    public static class Serializer
    implements RecipeSerializer<EmberActivationRecipe> {
        public EmberActivationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("input"));
            int ember = GsonHelper.m_13927_((JsonObject)json, (String)"ember");
            return new EmberActivationRecipe(recipeId, ingredient, ember);
        }

        @Nullable
        public EmberActivationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ember = buffer.m_130242_();
            return new EmberActivationRecipe(recipeId, ingredient, ember);
        }

        public void toNetwork(FriendlyByteBuf buffer, EmberActivationRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130130_(recipe.ember);
        }
    }
}

