/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.recipe.BoringContext;
import com.rekindled.embers.recipe.IBoringRecipe;
import com.rekindled.embers.util.WeightedItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BoringRecipe
implements IBoringRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final WeightedItemStack result;
    public final int minHeight;
    public final int maxHeight;
    public final HashSet<ResourceLocation> dimensions;
    public final HashSet<ResourceLocation> biomes;
    public final TagKey<Block> requiredBlock;
    public final int amountRequired;
    public final double chance;

    public BoringRecipe(ResourceLocation id, WeightedItemStack result, int minHeight, int maxHeight, HashSet<ResourceLocation> dimensions, HashSet<ResourceLocation> biomes, TagKey<Block> requiredBlock, int amountRequired, double chance) {
        this.id = id;
        this.result = result;
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.dimensions = dimensions;
        this.biomes = biomes;
        this.requiredBlock = requiredBlock;
        this.amountRequired = amountRequired;
        this.chance = chance;
    }

    public boolean matches(BoringContext context, Level pLevel) {
        if (!this.dimensions.isEmpty() && !this.dimensions.contains(context.dimension)) {
            return false;
        }
        if (!this.biomes.isEmpty() && !this.biomes.contains(context.biome)) {
            return false;
        }
        if (this.amountRequired > 0) {
            int amountLeft = this.amountRequired;
            for (BlockState state : context.blocks) {
                if (state.m_204336_(this.requiredBlock)) {
                    --amountLeft;
                }
                if (amountLeft < 1) break;
            }
            if (amountLeft > 0) {
                return false;
            }
        }
        return context.height >= this.minHeight && context.height <= this.maxHeight;
    }

    @Override
    public WeightedItemStack getOutput(BoringContext context) {
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess registry) {
        return this.result.getStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public Collection<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Collection<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public WeightedItemStack getDisplayOutput() {
        return this.result;
    }

    @Override
    public List<ItemStack> getDisplayInput() {
        ArrayList list = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.f_256975_.m_206058_(this.requiredBlock)) {
            list.add(new ItemStack((ItemLike)holder.get(), this.amountRequired));
        }
        return list;
    }

    public static class Serializer
    implements RecipeSerializer<BoringRecipe> {
        public BoringRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray biomeJson;
            ItemStack stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
            int minHeight = GsonHelper.m_13824_((JsonObject)json, (String)"min_height", (int)Integer.MIN_VALUE);
            int maxHeight = GsonHelper.m_13824_((JsonObject)json, (String)"max_height", (int)Integer.MAX_VALUE);
            HashSet<ResourceLocation> dimensions = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> biomes = new HashSet<ResourceLocation>();
            double chance = GsonHelper.m_144742_((JsonObject)json, (String)"chance", (double)-1.0);
            JsonArray dimJson = GsonHelper.m_13832_((JsonObject)json, (String)"dimensions", null);
            if (dimJson != null) {
                for (Object element : dimJson) {
                    dimensions.add(new ResourceLocation(element.getAsString()));
                }
            }
            if ((biomeJson = GsonHelper.m_13832_((JsonObject)json, (String)"biomes", null)) != null) {
                for (JsonElement element : biomeJson) {
                    biomes.add(new ResourceLocation(element.getAsString()));
                }
            }
            ResourceLocation requiredBlock = null;
            int amountRequired = 0;
            JsonObject blockJson = json.getAsJsonObject("required_block");
            if (blockJson != null) {
                requiredBlock = new ResourceLocation(blockJson.get("block_tag").getAsString());
                amountRequired = GsonHelper.m_13824_((JsonObject)blockJson, (String)"amount", (int)0);
            }
            return new BoringRecipe(recipeId, new WeightedItemStack(stack, weight), minHeight, maxHeight, dimensions, biomes, (TagKey<Block>)BlockTags.create((ResourceLocation)requiredBlock), amountRequired, chance);
        }

        @Nullable
        public BoringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack stack = buffer.m_130267_();
            int weight = buffer.m_130242_();
            int minHeight = buffer.m_130242_();
            int maxHeight = buffer.m_130242_();
            HashSet dimensions = (HashSet)buffer.m_236838_(i -> new HashSet(), FriendlyByteBuf::m_130281_);
            HashSet biomes = (HashSet)buffer.m_236838_(i -> new HashSet(), FriendlyByteBuf::m_130281_);
            ResourceLocation requiredBlock = buffer.m_130281_();
            int amountRequired = buffer.m_130242_();
            double chance = buffer.readDouble();
            return new BoringRecipe(recipeId, new WeightedItemStack(stack, weight), minHeight, maxHeight, dimensions, biomes, (TagKey<Block>)BlockTags.create((ResourceLocation)requiredBlock), amountRequired, chance);
        }

        public void toNetwork(FriendlyByteBuf buffer, BoringRecipe recipe) {
            buffer.writeItemStack(recipe.result.getStack(), false);
            buffer.m_130130_(recipe.result.m_142631_().m_146281_());
            buffer.m_130130_(recipe.minHeight);
            buffer.m_130130_(recipe.maxHeight);
            buffer.m_236828_(recipe.dimensions, FriendlyByteBuf::m_130085_);
            buffer.m_236828_(recipe.biomes, FriendlyByteBuf::m_130085_);
            buffer.m_130085_(recipe.requiredBlock.f_203868_());
            buffer.m_130130_(recipe.amountRequired);
            buffer.writeDouble(recipe.chance);
        }
    }
}

