/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.recipe.AnvilDisplayRecipe;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.recipe.IVisuallySplitRecipe;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilBreakdownRecipe
implements IDawnstoneAnvilRecipe,
IVisuallySplitRecipe<IDawnstoneAnvilRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public static List<IDawnstoneAnvilRecipe> visualRecipes = new ArrayList<IDawnstoneAnvilRecipe>();
    Ingredient blacklist = Ingredient.m_204132_(EmbersItemTags.BREAKDOWN_BLACKLIST);

    public AnvilBreakdownRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5818_(Container context, Level pLevel) {
        ItemStack tool = context.m_8020_(0);
        return tool.isRepairable() && !this.blacklist.test(tool) && context.m_8020_(1).m_41619_() && !AugmentUtil.hasHeat(tool);
    }

    @Override
    public List<ItemStack> getOutput(Container context) {
        Ingredient repairMaterial = Misc.getRepairIngredient(context.m_8020_(0).m_41720_());
        if (!repairMaterial.m_43947_()) {
            return List.of(Misc.getPreferredItem(repairMaterial.m_43908_()));
        }
        return List.of();
    }

    @Override
    public List<IDawnstoneAnvilRecipe> getVisualRecipes() {
        visualRecipes.clear();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206115_()) {
            Ingredient repairMaterial = Misc.getRepairIngredient((Item)holder.get());
            ItemStack toolStack = new ItemStack((ItemLike)holder.get());
            if (repairMaterial.m_43947_() || !toolStack.isRepairable() || this.blacklist.test(toolStack)) continue;
            ItemStack brokenTool = toolStack.m_41777_();
            brokenTool.m_41721_(brokenTool.m_41776_() / 2);
            visualRecipes.add(new AnvilDisplayRecipe(this.id, List.of(Misc.getPreferredItem(repairMaterial.m_43908_())), List.of(brokenTool), Ingredient.f_43901_));
        }
        return visualRecipes;
    }

    @Override
    public List<ItemStack> getDisplayInputBottom() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayInputTop() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayOutput() {
        return List.of();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilBreakdownRecipe> {
        public AnvilBreakdownRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new AnvilBreakdownRecipe(recipeId);
        }

        @Nullable
        public AnvilBreakdownRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AnvilBreakdownRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilBreakdownRecipe recipe) {
        }
    }
}

