/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.augment.IAugment;
import com.rekindled.embers.recipe.AnvilAugmentRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class AnvilAugmentRecipeBuilder {
    public ResourceLocation id;
    public Ingredient tool;
    public Ingredient input;
    public IAugment augment;

    public static AnvilAugmentRecipeBuilder create(IAugment augment) {
        AnvilAugmentRecipeBuilder builder = new AnvilAugmentRecipeBuilder();
        builder.augment = augment;
        builder.id = augment.getName();
        return builder;
    }

    public AnvilAugmentRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public AnvilAugmentRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public AnvilAugmentRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public AnvilAugmentRecipeBuilder tool(Ingredient tool) {
        this.tool = tool;
        return this;
    }

    public AnvilAugmentRecipeBuilder tool(ItemLike ... tool) {
        this.tool(Ingredient.m_43929_((ItemLike[])tool));
        return this;
    }

    public AnvilAugmentRecipeBuilder tool(TagKey<Item> tag) {
        this.tool(Ingredient.m_204132_(tag));
        return this;
    }

    public AnvilAugmentRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public AnvilAugmentRecipeBuilder input(ItemLike ... input) {
        this.input(Ingredient.m_43929_((ItemLike[])input));
        return this;
    }

    public AnvilAugmentRecipeBuilder input(TagKey<Item> tag) {
        this.input(Ingredient.m_204132_(tag));
        return this;
    }

    public AnvilAugmentRecipe build() {
        return new AnvilAugmentRecipe(this.id, this.tool, this.input, this.augment);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final AnvilAugmentRecipe recipe;

        public Finished(AnvilAugmentRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("tool", this.recipe.tool.m_43942_());
            json.add("input", this.recipe.input.m_43942_());
            json.addProperty("augment", this.recipe.augment.getName().toString());
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.TOOL_AUGMENT.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

