/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.augment.IAugment;
import com.rekindled.embers.recipe.AnvilDisplayRecipe;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.recipe.IVisuallySplitRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilAugmentRecipe
implements IDawnstoneAnvilRecipe,
IVisuallySplitRecipe<IDawnstoneAnvilRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient tool;
    public final Ingredient input;
    public final IAugment augment;
    public static List<IDawnstoneAnvilRecipe> visualRecipes = new ArrayList<IDawnstoneAnvilRecipe>();

    public AnvilAugmentRecipe(ResourceLocation id, Ingredient tool, Ingredient input, IAugment augment) {
        this.id = id;
        this.tool = tool;
        this.input = input;
        this.augment = augment;
    }

    public boolean m_5818_(Container context, Level pLevel) {
        if (this.augment.countTowardsTotalLevel()) {
            ItemStack toolStack = context.m_8020_(0);
            return this.tool.test(toolStack) && this.input.test(context.m_8020_(1)) && AugmentUtil.getLevel(toolStack) > AugmentUtil.getTotalAugmentLevel(toolStack);
        }
        return this.tool.test(context.m_8020_(0)) && this.input.test(context.m_8020_(1));
    }

    @Override
    public List<ItemStack> getOutput(Container context) {
        ItemStack result = context.m_8020_(0).m_41777_();
        AugmentUtil.addAugment(result, context.m_8020_(1), this.augment);
        return List.of(result);
    }

    @Override
    public List<IDawnstoneAnvilRecipe> getVisualRecipes() {
        visualRecipes.clear();
        for (ItemStack stack : this.tool.m_43908_()) {
            ItemStack leveledTool = stack.m_41777_();
            if (this.augment.countTowardsTotalLevel()) {
                AugmentUtil.setLevel(leveledTool, AugmentUtil.getLevel(leveledTool) + 1);
            }
            ItemStack augmentedTool = leveledTool.m_41777_();
            AugmentUtil.addAugment(augmentedTool, ItemStack.f_41583_, this.augment);
            visualRecipes.add(new AnvilDisplayRecipe(this.id, List.of(augmentedTool), List.of(leveledTool), this.input));
        }
        return visualRecipes;
    }

    @Override
    public List<ItemStack> getDisplayInputBottom() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayInputTop() {
        return List.of();
    }

    @Override
    public List<ItemStack> getDisplayOutput() {
        return List.of();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilAugmentRecipe> {
        public AnvilAugmentRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient tool = Ingredient.m_43917_((JsonElement)json.get("tool"));
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            IAugment augment = AugmentUtil.getAugment(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"augment")));
            return new AnvilAugmentRecipe(recipeId, tool, input, augment);
        }

        @Nullable
        public AnvilAugmentRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            IAugment augment = AugmentUtil.getAugment(buffer.m_130281_());
            return new AnvilAugmentRecipe(recipeId, tool, input, augment);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilAugmentRecipe recipe) {
            recipe.tool.m_43923_(buffer);
            recipe.input.m_43923_(buffer);
            buffer.m_130085_(recipe.augment.getName());
        }
    }
}

