/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.particle.GlowParticleOptions;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class AlchemyCircleParticleOptions
implements ParticleOptions {
    protected final Vector3f color;
    protected final float scale;
    protected final int lifetime;
    public static final AlchemyCircleParticleOptions DEFAULT = new AlchemyCircleParticleOptions(GlowParticleOptions.EMBER_COLOR, 1.0f, 420);
    public static final Codec<AlchemyCircleParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p_175797_ -> p_175797_.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_175795_ -> Float.valueOf(p_175795_.scale)), (App)Codec.INT.fieldOf("lifetime").forGetter(p_175795_ -> p_175795_.lifetime)).apply((Applicative)p_175793_, AlchemyCircleParticleOptions::new));
    public static final ParticleOptions.Deserializer<AlchemyCircleParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<AlchemyCircleParticleOptions>(){

        public AlchemyCircleParticleOptions fromCommand(ParticleType<AlchemyCircleParticleOptions> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            Vector3f vector3f = AlchemyCircleParticleOptions.readVector3f(p_123690_);
            p_123690_.expect(' ');
            float f = p_123690_.readFloat();
            int i = p_123690_.readInt();
            return new AlchemyCircleParticleOptions(vector3f, f, i);
        }

        public AlchemyCircleParticleOptions fromNetwork(ParticleType<AlchemyCircleParticleOptions> p_123692_, FriendlyByteBuf p_123693_) {
            return new AlchemyCircleParticleOptions(AlchemyCircleParticleOptions.readVector3f(p_123693_), p_123693_.readFloat(), p_123693_.readInt());
        }
    };

    public AlchemyCircleParticleOptions(Vector3f pColor, float pScale, int lifetime) {
        this.color = pColor;
        this.scale = pScale;
        this.lifetime = lifetime;
    }

    public static Vector3f readVector3f(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        float f = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f1 = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f2 = pStringInput.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf pBuffer) {
        return new Vector3f(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat());
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.writeFloat(this.color.x());
        pBuffer.writeFloat(this.color.y());
        pBuffer.writeFloat(this.color.z());
        pBuffer.writeFloat(this.scale);
        pBuffer.writeInt(this.lifetime);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), Float.valueOf(this.scale), this.lifetime);
    }

    public Vector3f getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RegistryManager.ALCHEMY_CIRCLE_PARTICLE.get();
    }
}

