/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.power.IEmberPacketProducer;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.api.tile.ITargetable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TinkerHammerItem
extends Item {
    public TinkerHammerItem(Item.Properties pProperties) {
        super(pProperties);
        EmbersAPI.registerLinkingHammer(this);
        EmbersAPI.registerHammerTargetGetter(this);
    }

    public final ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return new ItemStack((ItemLike)this, stack.m_41613_(), stack.m_41783_());
        }
        return stack.m_41777_();
    }

    public boolean m_41470_() {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        CompoundTag nbt = stack.m_41784_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        if (world != null && nbt.m_128441_("targetWorld") && world.m_46472_().m_135782_().toString().equals(nbt.m_128461_("targetWorld"))) {
            BlockPos targetPos = new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ"));
            BlockEntity targetTile = world.m_7702_(targetPos);
            if (targetTile instanceof IEmberPacketProducer) {
                if (tile instanceof IEmberPacketReceiver) {
                    ((IEmberPacketProducer)targetTile).setTargetPosition(pos, Direction.m_122402_((String)nbt.m_128461_("targetFace")));
                    world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.5f + world.f_46441_.m_188501_() * 0.1f, false);
                    nbt.m_128473_("targetWorld");
                    return InteractionResult.SUCCESS;
                }
            } else if (targetTile instanceof ITargetable) {
                ((ITargetable)targetTile).setTarget(pos);
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.5f + world.f_46441_.m_188501_() * 0.1f, false);
                nbt.m_128473_("targetWorld");
                return InteractionResult.SUCCESS;
            }
        }
        if (world != null && (tile instanceof IEmberPacketProducer || tile instanceof ITargetable)) {
            Direction face = context.m_43719_();
            if (tile instanceof IEmberPacketProducer && (face = ((IEmberPacketProducer)tile).getEmittingDirection(face)) == null) {
                return InteractionResult.PASS;
            }
            nbt.m_128359_("targetWorld", world.m_46472_().m_135782_().toString());
            nbt.m_128359_("targetFace", face.m_122433_());
            nbt.m_128405_("targetX", pos.m_123341_());
            nbt.m_128405_("targetY", pos.m_123342_());
            nbt.m_128405_("targetZ", pos.m_123343_());
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.95f + world.f_46441_.m_188501_() * 0.2f, false);
            if (world.f_46443_) {
                EmbersClientEvents.lastTarget = null;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        CompoundTag nbt;
        if (level != null && stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("targetWorld")) {
            String dimension = nbt.m_128461_("targetWorld");
            if (level.m_46472_().m_135782_().toString().equals(dimension)) {
                BlockPos pos = new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ"));
                BlockState blockState = level.m_8055_(pos);
                tooltip.add((Component)Component.m_237110_((String)"embers.tooltip.aiming_block", (Object[])new Object[]{blockState.m_60734_().m_49954_()}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)(" X=" + pos.m_123341_())).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)(" Y=" + pos.m_123342_())).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)(" Z=" + pos.m_123343_())).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

