/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.power.DefaultEmberItemCapability;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.Misc;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public abstract class EmberStorageItem
extends Item {
    public EmberStorageItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack withFill(Item item, double ember) {
        ItemStack stack = new ItemStack((ItemLike)item);
        IEmberCapability cap = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        cap.setEmber(ember);
        return stack;
    }

    public abstract double getCapacity();

    public boolean m_142522_(ItemStack stack) {
        return stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).isPresent();
    }

    public int m_142158_(ItemStack stack) {
        IEmberCapability cap = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        if (cap != null) {
            return Math.round(13.0f - (float)(cap.getEmberCapacity() - cap.getEmber()) * 13.0f / (float)cap.getEmberCapacity());
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int m_142159_(ItemStack pStack) {
        return 0xFF6600;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new DefaultEmberItemCapability(stack, this.getCapacity());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        IEmberCapability cap = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
        if (cap != null) {
            DecimalFormat emberFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember");
            tooltip.add((Component)Component.m_237110_((String)"embers.tooltip.item.ember", (Object[])new Object[]{emberFormat.format(cap.getEmber()), emberFormat.format(cap.getEmberCapacity())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColorHandler
    implements ItemColor {
        public int m_92671_(ItemStack stack, int tintIndex) {
            IEmberCapability capability;
            if (tintIndex == 0 && (capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).orElse(null)) != null) {
                float coeff = (float)(capability.getEmber() / capability.getEmberCapacity());
                float timerSine = ((float)Math.sin(8.0 * Math.toRadians(EmbersClientEvents.ticks % 360)) + 1.0f) / 2.0f;
                int r = 255;
                int g = (int)(255.0f * (1.0f - coeff) + (64.0f * timerSine + 64.0f) * coeff);
                int b = (int)(255.0f * (1.0f - coeff) + 16.0f * coeff);
                return Misc.intColor(r, g, b);
            }
            return 0xFFFFFF;
        }
    }
}

