/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.api.item.IEmberChargedTool;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.util.EmberInventoryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ClockworkToolItem
extends DiggerItem
implements IEmberChargedTool {
    public ClockworkToolItem(float attackDamageModifier, float attackSpeedModifier, Tier tier, TagKey<Block> blocks, Item.Properties properties) {
        super(attackDamageModifier, attackSpeedModifier, tier, blocks, properties);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.hasEmber(stack)) {
            entity.m_20254_(2);
            return false;
        }
        return true;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.hasEmber(stack)) {
            return super.m_8102_(stack, state);
        }
        return 0.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41784_().m_128379_("didUse", true);
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)GlowParticleOptions.EMBER, target.m_20185_(), target.m_20186_() + (double)target.m_20192_() / 1.5, target.m_20189_(), 70, 0.15, 0.15, 0.15, 0.6);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        stack.m_41784_().m_128379_("didUse", true);
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant.f_44672_ != EnchantmentCategory.BREAKABLE && enchant != Enchantments.f_44983_;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41782_() && newStack.m_41782_()) {
            return slotChanged || oldStack.m_41783_().m_128471_("poweredOn") != newStack.m_41783_().m_128471_("poweredOn") || newStack.m_41720_() != oldStack.m_41720_();
        }
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41782_() && newStack.m_41782_()) {
            return oldStack.m_41783_().m_128471_("poweredOn") != newStack.m_41783_().m_128471_("poweredOn");
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!selected || world.m_5776_()) {
            return;
        }
        if (!stack.m_41782_()) {
            stack.m_41784_();
            stack.m_41783_().m_128379_("poweredOn", false);
            stack.m_41783_().m_128379_("didUse", false);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            if (world.m_46467_() % 5L == 0L) {
                if (EmberInventoryUtil.getEmberTotal(player) > 5.0) {
                    if (!stack.m_41783_().m_128471_("poweredOn")) {
                        stack.m_41783_().m_128379_("poweredOn", true);
                    }
                } else if (stack.m_41783_().m_128471_("poweredOn")) {
                    stack.m_41783_().m_128379_("poweredOn", false);
                }
            }
            if (stack.m_41783_().m_128471_("didUse")) {
                stack.m_41783_().m_128379_("didUse", false);
                EmberInventoryUtil.removeEmber(player, 5.0);
                if (EmberInventoryUtil.getEmberTotal(player) < 5.0) {
                    stack.m_41783_().m_128379_("poweredOn", false);
                }
            }
        }
    }

    @Override
    public boolean hasEmber(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("poweredOn");
    }
}

