/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.datagen.EmbersPlacedFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class EmbersBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ORE_LEAD_KEY = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("embers", "add_lead_ore"));
    public static final ResourceKey<BiomeModifier> ORE_SILVER_KEY = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("embers", "add_silver_ore"));
    public static final ResourceKey<BiomeModifier> GOLEM_SPAWN = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("embers", "add_golem_spawn"));
    public static final TagKey<Biome> NO_MONSTERS = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("forge", "no_default_monsters"));

    public static void generate(BootstapContext<BiomeModifier> bootstrap) {
        HolderGetter placed = bootstrap.m_255420_(Registries.f_256988_);
        HolderGetter biome = bootstrap.m_255420_(ForgeRegistries.Keys.BIOMES);
        HolderSet.Named overworldBiomes = biome.m_254956_(BiomeTags.f_215817_);
        List<HolderSet.Named> biomeBlackList = List.of(biome.m_254956_(Tags.Biomes.IS_MUSHROOM), HolderSet.m_205809_((Holder[])new Holder[]{biome.m_255043_(Biomes.f_220594_)}), biome.m_254956_(NO_MONSTERS));
        AndHolderSet hostileSpawns = new AndHolderSet(List.of(overworldBiomes, new NotHolderSetWrapper(new OrHolderSet(biomeBlackList))));
        bootstrap.m_255272_(ORE_LEAD_KEY, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldBiomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(EmbersPlacedFeatures.ORE_LEAD_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstrap.m_255272_(ORE_SILVER_KEY, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldBiomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(EmbersPlacedFeatures.ORE_SILVER_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstrap.m_255272_(GOLEM_SPAWN, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)hostileSpawns, List.of(new MobSpawnSettings.SpawnerData((EntityType)RegistryManager.ANCIENT_GOLEM.get(), 15, 1, 1))));
    }

    public static class NotHolderSetWrapper<T>
    extends NotHolderSet<T> {
        public NotHolderSetWrapper(HolderSet<T> value) {
            super(null, value);
        }

        public boolean m_207277_(HolderOwner<T> holderOwner) {
            return true;
        }
    }
}

