/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.event.MachineRecipeEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.MelterTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.recipe.IMeltingRecipe;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MelterBottomBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IUpgradeable {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            MelterBottomBlockEntity.this.m_6596_();
        }
    };
    static Random random = new Random();
    int progress = -1;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    public boolean isWorking;
    public List<UpgradeContext> upgrades;
    public IMeltingRecipe cachedRecipe = null;

    public MelterBottomBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.MELTER_BOTTOM_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(8000.0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        if (nbt.m_128441_("progress")) {
            this.progress = nbt.m_128451_("progress");
        }
        this.isWorking = nbt.m_128471_("working");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128379_("working", this.isWorking);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("working", this.isWorking);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MelterBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.handleSound();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MelterBottomBlockEntity blockEntity) {
        MelterTopBlockEntity top = (MelterTopBlockEntity)level.m_7702_(pos.m_7494_());
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        if (top != null && !top.inventory.getStackInSlot(0).m_41619_()) {
            double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, (Double)ConfigManager.MELTER_EMBER_COST.get(), blockEntity.upgrades);
            if (blockEntity.capability.getEmber() >= emberCost) {
                boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
                if (!cancel) {
                    UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
                    blockEntity.capability.removeAmount(emberCost, true);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (random.nextInt(20) == 0) {
                            serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(GlowParticleOptions.EMBER_COLOR, random.nextFloat() + 0.45f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.85f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.125, 0.0, 0.125, 1.0);
                        }
                        if (random.nextInt(10) == 0) {
                            serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(SmokeParticleOptions.SMOKE_COLOR, 4.0f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.5f), (double)((float)pos.m_123343_() + 0.5f), 12, 0.125, 0.125, 0.125, 1.0);
                        }
                    }
                    blockEntity.isWorking = true;
                    ++blockEntity.progress;
                    if (blockEntity.progress >= UpgradeUtil.getWorkTime(blockEntity, (Integer)ConfigManager.MELTER_PROCESS_TIME.get(), blockEntity.upgrades)) {
                        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)top.inventory);
                        blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.MELTING.get(), wrapper, level);
                        if (blockEntity.cachedRecipe != null) {
                            FluidStack output = blockEntity.cachedRecipe.getOutput((Container)wrapper);
                            FluidTank tank = top.getTank();
                            if ((output = UpgradeUtil.transformOutput((BlockEntity)blockEntity, output, blockEntity.upgrades)) != null && tank.fill(output, IFluidHandler.FluidAction.SIMULATE) >= output.getAmount()) {
                                tank.fill(output, IFluidHandler.FluidAction.EXECUTE);
                                blockEntity.cachedRecipe.process((Container)wrapper);
                                top.m_6596_();
                                blockEntity.progress = 0;
                                UpgradeUtil.throwEvent(blockEntity, new MachineRecipeEvent.Success<IMeltingRecipe>(blockEntity, blockEntity.cachedRecipe), blockEntity.upgrades);
                            }
                        }
                    }
                } else {
                    blockEntity.isWorking = false;
                    if (blockEntity.progress > 0) {
                        blockEntity.progress = 0;
                    }
                }
            } else {
                blockEntity.isWorking = false;
                if (blockEntity.progress > 0) {
                    blockEntity.progress = 0;
                }
            }
        } else {
            blockEntity.isWorking = false;
            if (blockEntity.progress > 0) {
                blockEntity.progress = 0;
            }
        }
        blockEntity.m_6596_();
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.MELTER_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 1.0f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

