/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.google.common.collect.Lists;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.InfernoForgeTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class InfernoForgeBottomBlockEntity
extends BlockEntity
implements IExtraDialInformation,
ISoundController,
IUpgradeable {
    public static double EMBER_COST = 16.0;
    public static int MAX_LEVEL = 5;
    public static double MAX_CRYSTAL_VALUE = 115200.0;
    public static double CHANCE_MIDPOINT = 14400.0;
    public static int PROCESS_TIME = 200;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            InfernoForgeBottomBlockEntity.this.m_6596_();
        }
    };
    static Random random = new Random();
    public int progress = 0;
    public double emberValue = 0.0;
    public IEmberActivationRecipe cachedEmberRecipe = null;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();

    public InfernoForgeBottomBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.INFERNO_FORGE_BOTTOM_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(32000.0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        this.progress = nbt.m_128451_("progress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, InfernoForgeBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{Direction.DOWN});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.handleSound();
        if (blockEntity.progress > 0) {
            if (random.nextInt(10) == 0) {
                if (random.nextInt(3) == 0) {
                    level.m_7106_((ParticleOptions)SparkParticleOptions.EMBER, (double)((float)pos.m_123341_() - 0.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)((float)pos.m_123342_() + 1.75f), (double)((float)pos.m_123343_() - 0.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * random.nextFloat()), (double)(0.125f * (random.nextFloat() - 0.5f)));
                }
                if (random.nextInt(3) == 0) {
                    level.m_7106_((ParticleOptions)SparkParticleOptions.EMBER, (double)((float)pos.m_123341_() + 1.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)((float)pos.m_123342_() + 1.75f), (double)((float)pos.m_123343_() - 0.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * random.nextFloat()), (double)(0.125f * (random.nextFloat() - 0.5f)));
                }
                if (random.nextInt(3) == 0) {
                    level.m_7106_((ParticleOptions)SparkParticleOptions.EMBER, (double)((float)pos.m_123341_() + 1.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)((float)pos.m_123342_() + 1.75f), (double)((float)pos.m_123343_() + 1.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * random.nextFloat()), (double)(0.125f * (random.nextFloat() - 0.5f)));
                }
                if (random.nextInt(3) == 0) {
                    level.m_7106_((ParticleOptions)SparkParticleOptions.EMBER, (double)((float)pos.m_123341_() - 0.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)((float)pos.m_123342_() + 1.75f), (double)((float)pos.m_123343_() + 1.5f + 0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * (random.nextFloat() - 0.5f)), (double)(0.125f * random.nextFloat()), (double)(0.125f * (random.nextFloat() - 0.5f)));
                }
            }
            level.m_7106_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)((float)pos.m_123341_() - 0.3f), (double)((float)pos.m_123342_() + 1.85f), (double)((float)pos.m_123343_() - 0.3f), (double)(0.025f * (random.nextFloat() - 0.5f)), (double)(0.05f * (random.nextFloat() + 1.0f)), (double)(0.025f * (random.nextFloat() - 0.5f)));
            level.m_7106_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)((float)pos.m_123341_() + 1.3f), (double)((float)pos.m_123342_() + 1.85f), (double)((float)pos.m_123343_() - 0.3f), (double)(0.025f * (random.nextFloat() - 0.5f)), (double)(0.05f * (random.nextFloat() + 1.0f)), (double)(0.025f * (random.nextFloat() - 0.5f)));
            level.m_7106_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)((float)pos.m_123341_() + 1.3f), (double)((float)pos.m_123342_() + 1.85f), (double)((float)pos.m_123343_() + 1.3f), (double)(0.025f * (random.nextFloat() - 0.5f)), (double)(0.05f * (random.nextFloat() + 1.0f)), (double)(0.025f * (random.nextFloat() - 0.5f)));
            level.m_7106_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)((float)pos.m_123341_() - 0.3f), (double)((float)pos.m_123342_() + 1.85f), (double)((float)pos.m_123343_() + 1.3f), (double)(0.025f * (random.nextFloat() - 0.5f)), (double)(0.05f * (random.nextFloat() + 1.0f)), (double)(0.025f * (random.nextFloat() - 0.5f)));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfernoForgeBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{Direction.DOWN});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        BlockEntity blockEntity2 = level.m_7702_(pos.m_7494_());
        if (blockEntity2 instanceof InfernoForgeTopBlockEntity) {
            long openTicks;
            InfernoForgeTopBlockEntity hatch = (InfernoForgeTopBlockEntity)blockEntity2;
            if (!hatch.open && (openTicks = level.m_46467_() - hatch.lastToggle) > 7L) {
                blockEntity.updateProgress();
            }
        }
        if (blockEntity.progress <= 0) {
            if (level.m_46467_() % 20L == 1L) {
                List items = level.m_45976_(ItemEntity.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_() + 0.25, (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 1.0));
                for (ItemEntity e : items) {
                    e.m_32064_();
                }
            }
            return;
        }
        boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
        double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, EMBER_COST, blockEntity.upgrades);
        if (cancel || blockEntity.capability.getEmber() < emberCost) {
            blockEntity.progress = 0;
            blockEntity.m_6596_();
            BlockEntity blockEntity3 = level.m_7702_(pos.m_7494_());
            if (blockEntity3 instanceof InfernoForgeTopBlockEntity) {
                InfernoForgeTopBlockEntity hatch = (InfernoForgeTopBlockEntity)blockEntity3;
                hatch.open = true;
                hatch.lastToggle = level.m_46467_();
                hatch.m_6596_();
                level.m_5594_(null, pos, (SoundEvent)EmbersSounds.INFERNO_FORGE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return;
        }
        UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
        blockEntity.progress = (int)((double)blockEntity.progress - 1.0 * UpgradeUtil.getTotalSpeedModifier(blockEntity, blockEntity.upgrades));
        blockEntity.capability.removeAmount(emberCost, true);
        List<ItemEntity> items = blockEntity.getValidItems();
        for (ItemEntity e : items) {
            e.m_32064_();
            e.m_32010_(20);
        }
        if (blockEntity.progress != 0) {
            return;
        }
        if (items.isEmpty()) {
            blockEntity.progress = 0;
            blockEntity.m_6596_();
            return;
        }
        boolean forgeSuccess = false;
        BlockEntity blockEntity4 = level.m_7702_(pos.m_7494_());
        if (blockEntity4 instanceof InfernoForgeTopBlockEntity) {
            InfernoForgeTopBlockEntity hatch = (InfernoForgeTopBlockEntity)blockEntity4;
            hatch.open = true;
            hatch.lastToggle = level.m_46467_();
            hatch.m_6596_();
            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.INFERNO_FORGE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (blockEntity.emberValue > 0.0) {
            for (ItemEntity item : items) {
                if (!AugmentUtil.hasHeat(item.m_32055_())) {
                    if (item.m_32055_().m_204117_(ItemTags.f_13158_)) {
                        item.m_32045_(new ItemStack((ItemLike)RegistryManager.MUSIC_DISC_7F_PATTERNS.get()));
                        forgeSuccess = true;
                        continue;
                    }
                    item.m_146870_();
                    continue;
                }
                if (!(Misc.random.nextDouble() < UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "reforge_chance", Math.atan(blockEntity.emberValue / (CHANCE_MIDPOINT + (double)(14400 * AugmentUtil.getLevel(item.m_32055_())))) / 1.5707963267948966, blockEntity.upgrades))) continue;
                ItemStack stack = item.m_32055_();
                AugmentUtil.setHeat(stack, 0.0f);
                AugmentUtil.setLevel(stack, AugmentUtil.getLevel(stack) + 1);
                item.m_32045_(stack);
                blockEntity.progress = 0;
                forgeSuccess = true;
            }
        }
        level.m_5594_(null, pos.m_7494_(), forgeSuccess ? (SoundEvent)EmbersSounds.INFERNO_FORGE_SUCCESS.get() : (SoundEvent)EmbersSounds.INFERNO_FORGE_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (forgeSuccess) {
                serverLevel.m_8767_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, new Vec3(0.0, (double)0.65f, 0.0), 4.7f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.5f), (double)((float)pos.m_123343_() + 0.5f), 80, 0.1, 0.1, 0.1, 1.0);
            }
            serverLevel.m_8767_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 20, 0.1, 0.1, 0.1, 1.0);
        }
        blockEntity.m_6596_();
    }

    public void updateProgress() {
        if (this.progress != 0) {
            return;
        }
        List<ItemEntity> items = this.getValidItems();
        if (!items.isEmpty()) {
            this.progress = PROCESS_TIME;
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)EmbersSounds.INFERNO_FORGE_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.m_6596_();
        }
    }

    private List<ItemEntity> getValidItems() {
        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.25, (double)this.f_58858_.m_123343_(), (double)this.f_58858_.m_123341_() + 1.0, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 1.0));
        ItemStack pickedItem = ItemStack.f_41583_;
        this.emberValue = 0.0;
        for (ItemEntity item : items) {
            ItemStack stack = item.m_32055_();
            if (AugmentUtil.hasHeat(stack) || stack.m_204117_(ItemTags.f_13158_)) {
                if (pickedItem.m_41619_() && (AugmentUtil.getLevel(stack) < MAX_LEVEL && AugmentUtil.getHeat(stack) >= AugmentUtil.getMaxHeat(stack) || stack.m_204117_(ItemTags.f_13158_))) {
                    pickedItem = stack;
                    continue;
                }
                return Lists.newArrayList();
            }
            SingleItemContainer context = new SingleItemContainer(stack);
            this.cachedEmberRecipe = Misc.getRecipe(this.cachedEmberRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), context, this.f_58857_);
            if (this.cachedEmberRecipe != null) {
                this.emberValue += (double)(this.cachedEmberRecipe.getOutput(context) * stack.m_41613_());
                continue;
            }
            return Lists.newArrayList();
        }
        if (!pickedItem.m_41619_() && this.emberValue > 0.0) {
            return items;
        }
        return Lists.newArrayList();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Override
    public void playSound(int id) {
        if (id == 1) {
            EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.INFERNO_FORGE_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.progress > 0;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face == Direction.DOWN;
    }
}

