/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.CatalysisChamberBlockEntity;
import com.rekindled.embers.blockentity.CombustionChamberBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.joml.Vector3f;

public class IgnemReactorBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final double BASE_MULTIPLIER = 1.0;
    public static final int PROCESS_TIME = 20;
    static Random random = new Random();
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            IgnemReactorBlockEntity.this.m_6596_();
        }

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IgnemReactorBlockEntity.this.m_6596_();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (Misc.getRecipe(IgnemReactorBlockEntity.this.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), new SingleItemContainer(stack), IgnemReactorBlockEntity.this.f_58857_) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    int progress = -1;
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public IEmberActivationRecipe cachedRecipe = null;
    public double catalyzerMult;
    public double combustorMult;
    public static final int SOUND_HAS_EMBER = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public IgnemReactorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.IGNEM_REACTOR_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(128000.0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
        this.capability.deserializeNBT((Tag)nbt);
        if (nbt.m_128441_("progress")) {
            this.progress = nbt.m_128451_("progress");
        }
        this.catalyzerMult = nbt.m_128459_("catalyzer");
        this.combustorMult = nbt.m_128459_("combustor");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128347_("catalyzer", this.catalyzerMult);
        nbt.m_128347_("combustor", this.combustorMult);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.capability.writeToNBT(nbt);
        nbt.m_128347_("catalyzer", this.catalyzerMult);
        nbt.m_128347_("combustor", this.combustorMult);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, IgnemReactorBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.handleSound();
        if (blockEntity.capability.getEmber() > 0.0) {
            double catalyzerRatio = 0.0;
            if (blockEntity.catalyzerMult > 0.0 || blockEntity.combustorMult > 0.0) {
                catalyzerRatio = blockEntity.catalyzerMult / (blockEntity.catalyzerMult + blockEntity.combustorMult);
            }
            int r = (int)Mth.m_14085_((double)255.0, (double)255.0, (double)catalyzerRatio);
            int g = (int)Mth.m_14085_((double)64.0, (double)64.0, (double)catalyzerRatio);
            int b = (int)Mth.m_14085_((double)16.0, (double)64.0, (double)catalyzerRatio);
            float size = (float)Mth.m_14085_((double)4.0, (double)2.0, (double)catalyzerRatio);
            GlowParticleOptions options = new GlowParticleOptions(new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f), size);
            int i = 0;
            while ((double)i < Math.ceil(blockEntity.capability.getEmber() / 500.0)) {
                float vx = (float)Mth.m_14085_((double)0.0, (double)(((double)random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                float vy = (float)Mth.m_14085_((double)(random.nextFloat() * 0.05f), (double)(((double)random.nextFloat() - 0.5) * (double)0.2f), (double)catalyzerRatio);
                float vz = (float)Mth.m_14085_((double)0.0, (double)(((double)random.nextFloat() - 0.5) * (double)0.1f), (double)catalyzerRatio);
                level.m_7106_((ParticleOptions)options, (double)((float)pos.m_123341_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123342_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123343_() + 0.25f + random.nextFloat() * 0.5f), (double)vx, (double)vy, (double)vz);
                ++i;
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, IgnemReactorBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
        if (!cancel && !blockEntity.inventory.getStackInSlot(0).m_41619_()) {
            ++blockEntity.progress;
            if (blockEntity.progress > UpgradeUtil.getWorkTime(blockEntity, 20, blockEntity.upgrades)) {
                blockEntity.catalyzerMult = 0.0;
                blockEntity.combustorMult = 0.0;
                double multiplier = 1.0;
                for (Direction facing : Misc.horizontals) {
                    BlockEntity tile = level.m_7702_(pos.m_121945_(facing).m_7495_());
                    if (tile instanceof CatalysisChamberBlockEntity) {
                        blockEntity.catalyzerMult += ((CatalysisChamberBlockEntity)tile).multiplier;
                    }
                    if (!(tile instanceof CombustionChamberBlockEntity)) continue;
                    blockEntity.combustorMult += ((CombustionChamberBlockEntity)tile).multiplier;
                }
                if (Math.max(blockEntity.combustorMult, blockEntity.catalyzerMult) < 2.0 * Math.min(blockEntity.combustorMult, blockEntity.catalyzerMult)) {
                    multiplier += blockEntity.combustorMult;
                    multiplier += blockEntity.catalyzerMult;
                    blockEntity.progress = 0;
                    if (blockEntity.inventory != null) {
                        double emberValue;
                        double ember;
                        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)blockEntity.inventory);
                        blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), wrapper, level);
                        if (blockEntity.cachedRecipe != null && (ember = UpgradeUtil.getTotalEmberProduction(blockEntity, multiplier * (emberValue = (double)blockEntity.cachedRecipe.getOutput((Container)wrapper)), blockEntity.upgrades)) > 0.0 && blockEntity.capability.getEmber() + ember <= blockEntity.capability.getEmberCapacity()) {
                            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.IGNEM_REACTOR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverLevel.m_8767_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, new Vec3(0.0, (double)0.65f, 0.0), 4.7f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 80, 0.1, 0.1, 0.1, 1.0);
                                serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(SmokeParticleOptions.SMOKE_COLOR, 5.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.1, 0.1, 0.1, 1.0);
                            }
                            UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.PRODUCE, ember), blockEntity.upgrades);
                            blockEntity.capability.addAmount(ember, true);
                            blockEntity.cachedRecipe.process((Container)wrapper);
                        }
                    }
                }
            }
            blockEntity.m_6596_();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
            }
            if (cap == EmbersCapabilities.EMBER_CAPABILITY) {
                return this.capability.getCapability(cap, side);
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
        this.capability.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.GENERATOR_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.capability.getEmber() > 0.0;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        return (float)((this.capability.getEmber() + 5000.0) / (this.capability.getEmberCapacity() + 5000.0));
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER || capability == EmbersCapabilities.EMBER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember")));
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.ember", null));
        }
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        if ("ember".equals(dialType) && Math.max(this.combustorMult, this.catalyzerMult) < 2.0 * Math.min(this.combustorMult, this.catalyzerMult)) {
            DecimalFormat multiplierFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = 1.0 + this.combustorMult + this.catalyzerMult;
            information.add((Component)Component.m_237110_((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

