/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.api.tile.IFluidPipePriority;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.util.PipePriorityMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class FluidPipeBlockEntityBase
extends PipeBlockEntityBase
implements IFluidPipePriority {
    public static final int MAX_PUSH = 120;
    public FluidTank tank;
    public LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FluidPipeBlockEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.initFluidTank();
    }

    protected void initFluidTank() {
        this.tank = new FluidTank(this.getCapacity()){

            protected void onContentsChanged() {
                FluidPipeBlockEntityBase.this.m_6596_();
            }
        };
    }

    public abstract int getCapacity();

    @Override
    public int getPriority(Direction facing) {
        return 0;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FluidPipeBlockEntityBase blockEntity) {
        if (!blockEntity.loaded) {
            blockEntity.initConnections();
        }
        ++blockEntity.ticksExisted;
        boolean fluidMoved = false;
        FluidStack passStack = blockEntity.tank.drain(120, IFluidHandler.FluidAction.SIMULATE);
        if (!passStack.isEmpty()) {
            IFluidHandler handler;
            PipePriorityMap<Integer, Direction> possibleDirections = new PipePriorityMap<Integer, Direction>();
            IFluidHandler[] fluidHandlers = new IFluidHandler[Direction.values().length];
            for (Direction facing : Direction.values()) {
                BlockEntity tile;
                if (!blockEntity.getConnection((Direction)facing).transfer || blockEntity.isFrom(facing) || (tile = level.m_7702_(pos.m_121945_(facing))) == null || (handler = (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.m_122424_()).orElse(null)) == null) continue;
                int priority = 0;
                if (tile instanceof IFluidPipePriority) {
                    priority = ((IFluidPipePriority)tile).getPriority(facing.m_122424_());
                }
                if (blockEntity.isFrom(facing.m_122424_())) {
                    priority -= 5;
                }
                possibleDirections.put(priority, facing);
                fluidHandlers[facing.m_122411_()] = handler;
            }
            Iterator iterator = possibleDirections.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                ArrayList list = possibleDirections.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    Direction facing = (Direction)list.get((i + blockEntity.lastRobin) % list.size());
                    handler = fluidHandlers[facing.m_122411_()];
                    fluidMoved = blockEntity.pushStack(passStack, facing, handler);
                    if (blockEntity.lastTransfer != facing) {
                        blockEntity.lastTransfer = facing;
                        blockEntity.syncTransfer = true;
                        blockEntity.m_6596_();
                    }
                    if (!fluidMoved) continue;
                    ++blockEntity.lastRobin;
                    break;
                }
                if (!fluidMoved) continue;
                break;
            }
        }
        if (blockEntity.tank.getFluidAmount() <= 0) {
            if (blockEntity.lastTransfer != null && !fluidMoved) {
                blockEntity.lastTransfer = null;
                blockEntity.syncTransfer = true;
                blockEntity.m_6596_();
            }
            fluidMoved = true;
            blockEntity.resetFrom();
        }
        if (blockEntity.clogged == fluidMoved) {
            blockEntity.clogged = !fluidMoved;
            blockEntity.syncCloggedFlag = true;
            blockEntity.m_6596_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level level, BlockPos pos, BlockState state, FluidPipeBlockEntityBase blockEntity) {
        PipeBlockEntityBase.clientTick(level, pos, state, blockEntity);
    }

    private boolean pushStack(FluidStack passStack, Direction facing, IFluidHandler handler) {
        int added = handler.fill(passStack, IFluidHandler.FluidAction.SIMULATE);
        if (added > 0) {
            handler.fill(passStack, IFluidHandler.FluidAction.EXECUTE);
            this.tank.drain(added, IFluidHandler.FluidAction.EXECUTE);
            passStack.setAmount(passStack.getAmount() - added);
            return passStack.getAmount() <= 0;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("tank")) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeTank(nbt);
    }

    public void writeTank(CompoundTag nbt) {
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }
}

