/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IEmberInjectable;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EmberInjectorBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IUpgradeable {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            EmberInjectorBlockEntity.this.m_6596_();
        }
    };
    protected int ticksExisted = 0;
    protected int progress = -1;
    static Random random = new Random();
    public static final double EMBER_COST = 1.0;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    public List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public boolean isWorking;
    public int distance;

    public EmberInjectorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_INJECTOR_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(24000.0);
        this.capability.setEmber(0.0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        this.isWorking = nbt.m_128471_("isWorking");
        this.distance = nbt.m_128451_("distance");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128379_("isWorking", this.isWorking);
        nbt.m_128405_("distance", this.distance);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("isWorking", this.isWorking);
        nbt.m_128405_("distance", this.distance);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EmberInjectorBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.handleSound();
        if (blockEntity.isWorking) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            for (int i = 0; i < 6 * blockEntity.distance; ++i) {
                level.m_7106_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, 4.0f), (double)((float)pos.m_123341_() + 0.5f + random.nextFloat() * (float)blockEntity.distance * (float)facing.m_122436_().m_123341_()), (double)((float)pos.m_123342_() + 0.5f + random.nextFloat() * (float)blockEntity.distance * (float)facing.m_122436_().m_123342_()), (double)((float)pos.m_123343_() + 0.5f + random.nextFloat() * (float)blockEntity.distance * (float)facing.m_122436_().m_123343_()), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberInjectorBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        boolean wasWorking = blockEntity.isWorking;
        int previousDist = blockEntity.distance;
        if (!UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            boolean cancel;
            IEmberInjectable injectable;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            int maxDist = UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "distance", ((Integer)ConfigManager.INJECTOR_MAX_DISTANCE.get()).intValue(), blockEntity.upgrades);
            BlockPos hitPos = pos;
            BlockEntity tile = null;
            for (int i = 1; i <= maxDist + 1; ++i) {
                BlockState hitState = level.m_8055_(hitPos = hitPos.m_121945_(facing));
                if (hitState.m_60812_((BlockGetter)level, hitPos).m_83281_()) continue;
                tile = level.m_7702_(hitPos);
                blockEntity.distance = i;
                break;
            }
            blockEntity.isWorking = false;
            double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, 1.0, blockEntity.upgrades);
            if (tile instanceof IEmberInjectable && (injectable = (IEmberInjectable)tile).isValid() && blockEntity.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades))) {
                double enberInjected = 1.0 * UpgradeUtil.getTotalSpeedModifier(blockEntity, blockEntity.upgrades);
                injectable.inject(blockEntity, enberInjected);
                UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
                blockEntity.isWorking = true;
                blockEntity.capability.removeAmount(emberCost, true);
            }
        }
        if (wasWorking != blockEntity.isWorking || previousDist != blockEntity.distance) {
            blockEntity.m_6596_();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.INJECTOR_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return true;
    }
}

