/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.blockentity.EmberEmitterBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EmberEjectorBlockEntity
extends EmberEmitterBlockEntity {
    public static final double TRANSFER_RATE = 400.0;
    public static final double PULL_RATE = 100.0;

    public EmberEjectorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_EJECTOR_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(2000.0);
        this.capability.setEmber(0.0);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberEjectorBlockEntity blockEntity) {
        BlockEntity targetTile;
        IEmberCapability cap;
        ++blockEntity.ticksExisted;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity attachedTile = level.m_7702_(pos.m_5484_(facing, -1));
        if (blockEntity.ticksExisted % 5L == 0L && attachedTile != null && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing).orElse(null)) != null && cap.getEmber() > 0.0 && blockEntity.capability.getEmber() < blockEntity.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(100.0, true);
            blockEntity.capability.addAmount(removed, true);
        }
        if ((blockEntity.ticksExisted + (long)blockEntity.offset) % 20L == 0L && level.m_276867_(pos) && blockEntity.target != null && level.m_46749_(blockEntity.target) && !level.f_46443_ && blockEntity.capability.getEmber() > 100.0 && (targetTile = level.m_7702_(blockEntity.target)) instanceof IEmberPacketReceiver && ((IEmberPacketReceiver)targetTile).hasRoomFor(400.0)) {
            EmberPacketEntity packet = (EmberPacketEntity)((EntityType)RegistryManager.EMBER_PACKET.get()).m_20615_(blockEntity.f_58857_);
            Vec3 velocity = EmberEjectorBlockEntity.getBurstVelocity(facing);
            packet.initCustom(pos, blockEntity.target, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, Math.min(400.0, blockEntity.capability.getEmber()));
            blockEntity.capability.removeAmount(Math.min(400.0, blockEntity.capability.getEmber()), true);
            blockEntity.f_58857_.m_7967_((Entity)packet);
            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.EMBER_EMIT_BIG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

