/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.EmberActivatorTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class EmberActivatorBottomBlockEntity
extends BlockEntity
implements IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final int PROCESS_TIME = 40;
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EmberActivatorBottomBlockEntity.this.m_6596_();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (Misc.getRecipe(EmberActivatorBottomBlockEntity.this.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), new SingleItemContainer(stack), EmberActivatorBottomBlockEntity.this.f_58857_) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public IEmberActivationRecipe cachedRecipe = null;

    public EmberActivatorBottomBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_ACTIVATOR_BOTTOM_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("progress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("progress", this.progress);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EmberActivatorBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberActivatorBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        if (!blockEntity.inventory.getStackInSlot(0).m_41619_()) {
            BlockEntity tile = level.m_7702_(pos.m_7494_());
            boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
            if (!cancel && tile instanceof EmberActivatorTopBlockEntity) {
                EmberActivatorTopBlockEntity top = (EmberActivatorTopBlockEntity)tile;
                ++blockEntity.progress;
                if (blockEntity.progress > UpgradeUtil.getWorkTime(blockEntity, 40, blockEntity.upgrades)) {
                    blockEntity.progress = 0;
                    if (blockEntity.inventory != null) {
                        double emberValue;
                        double ember;
                        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)blockEntity.inventory);
                        blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), wrapper, level);
                        if (blockEntity.cachedRecipe != null && ((ember = UpgradeUtil.getTotalEmberProduction(blockEntity, emberValue = (double)blockEntity.cachedRecipe.getOutput((Container)wrapper), blockEntity.upgrades)) > 0.0 || emberValue == 0.0) && top.capability.getEmber() + ember <= top.capability.getEmberCapacity()) {
                            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.ACTIVATOR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverLevel.m_8767_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, new Vec3(0.0, (double)0.65f, 0.0), 4.7f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.5f), (double)((float)pos.m_123343_() + 0.5f), 80, 0.1, 0.1, 0.1, 1.0);
                                serverLevel.m_8767_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 20, 0.1, 0.1, 0.1, 1.0);
                            }
                            UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.PRODUCE, ember), blockEntity.upgrades);
                            top.capability.addAmount(ember, true);
                            blockEntity.cachedRecipe.process((Container)wrapper);
                        }
                    }
                }
                blockEntity.m_6596_();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember")));
        }
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

