/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.tile.IBin;
import com.rekindled.embers.api.tile.IHammerable;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.util.Misc;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DawnstoneAnvilBlockEntity
extends BlockEntity
implements IHammerable {
    int progress = 0;
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            DawnstoneAnvilBlockEntity.this.m_6596_();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    static Random random = new Random();
    public IDawnstoneAnvilRecipe cachedRecipe = null;

    public DawnstoneAnvilBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.DAWNSTONE_ANVIL_ENTITY.get(), pPos, pBlockState);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, 0, 0), this.f_58858_.m_7918_(1, 2, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("progress");
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("progress", this.progress);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public boolean onHit() {
        RecipeWrapper context = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
        this.cachedRecipe = Misc.getRecipe(this.cachedRecipe, (RecipeType)RegistryManager.DAWNSTONE_ANVIL_RECIPE.get(), context, this.f_58857_);
        if (this.cachedRecipe != null) {
            ++this.progress;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.25f, 2.0f + random.nextFloat());
            if (this.progress > (Integer)ConfigManager.DAWNSTONE_ANVIL_MAX_HITS.get()) {
                this.progress = 0;
                List<ItemStack> results = this.cachedRecipe.getOutput((Container)context);
                for (ItemStack result : results) {
                    BlockEntity bin = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
                    if (bin instanceof IBin) {
                        ItemStack remainder = ((IBin)bin).getInventory().insertItem(0, result, false);
                        if (remainder.m_41619_() || this.f_58857_.m_5776_()) continue;
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)((float)this.f_58858_.m_123342_() + 1.0625f), (double)this.f_58858_.m_123343_() + 0.5, remainder));
                        continue;
                    }
                    if (this.f_58857_.m_5776_()) continue;
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)((float)this.f_58858_.m_123342_() + 1.0625f), (double)this.f_58858_.m_123343_() + 0.5, result));
                }
                this.inventory.setStackInSlot(0, ItemStack.f_41583_);
                this.inventory.setStackInSlot(1, ItemStack.f_41583_);
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(GlowParticleOptions.EMBER_COLOR, 1.0f), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.0625f), (double)((float)this.f_58858_.m_123343_() + 0.5f), 10, 0.1, 0.0, 0.1, 1.0);
                    serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(SmokeParticleOptions.SMOKE_COLOR, 3.0f), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.0625f), (double)((float)this.f_58858_.m_123343_() + 0.5f), 10, 0.1, 0.0, 0.1, 1.0);
                }
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 0.95f + random.nextFloat() * 0.1f);
            } else {
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.m_6596_();
                    serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(GlowParticleOptions.EMBER_COLOR, 1.0f), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.0625f), (double)((float)this.f_58858_.m_123343_() + 0.5f), 1, 0.02, 0.0, 0.02, 1.0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onHit(BlockEntity hammer) {
        this.progress = (Integer)ConfigManager.DAWNSTONE_ANVIL_MAX_HITS.get();
        this.onHit();
    }

    @Override
    public boolean isValid() {
        this.cachedRecipe = Misc.getRecipe(this.cachedRecipe, (RecipeType)RegistryManager.DAWNSTONE_ANVIL_RECIPE.get(), new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.f_58857_);
        return this.cachedRecipe != null;
    }
}

