/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.tile.IEmberInjectable;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalSeedBlockEntity
extends BlockEntity
implements IEmberInjectable,
ISoundController,
IExtraCapabilityInformation {
    public String type;
    public ResourceLocation texture;
    public TagKey<Item> tag;
    public boolean[] willSpawn;
    public int size = 0;
    public int xp = 0;
    public static int bonusParts = 0;
    public int ticksExisted = 0;
    protected static Random random = new Random();
    public static final int SOUND_AMBIENT = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public CrystalSeedBlockEntity(BlockPos pos, BlockState blockState, String type) {
        this((BlockEntityType)RegistryManager.MetalCrystalSeed.seeds.get((Object)type).BLOCKENTITY.get(), pos, blockState, type);
    }

    public CrystalSeedBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, String type) {
        super(entityType, pos, blockState);
        this.willSpawn = CrystalSeedBlockEntity.getSpawns(this.xp);
        this.type = type;
        this.texture = new ResourceLocation("embers:textures/block/material_" + type + ".png");
        this.tag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuggets/" + type));
    }

    public static boolean[] getSpawns(int xp) {
        int segments = Math.max(6 + bonusParts, 1);
        boolean[] willSpawn = new boolean[segments += CrystalSeedBlockEntity.getLevelBonus(CrystalSeedBlockEntity.getLevel(xp))];
        for (int i = 0; i < willSpawn.length; ++i) {
            willSpawn[i] = random.nextInt(3) == 0;
        }
        return willSpawn;
    }

    public static int getLevelBonus(int level) {
        if (level > 50) {
            return CrystalSeedBlockEntity.getLevelBonus(50) + (level - 50) / 25;
        }
        if (level > 20) {
            return CrystalSeedBlockEntity.getLevelBonus(20) + (level - 20) / 10;
        }
        if (level > 10) {
            return CrystalSeedBlockEntity.getLevelBonus(10) + (level - 10) / 5;
        }
        if (level > 5) {
            return CrystalSeedBlockEntity.getLevelBonus(5) + (level - 5) / 3;
        }
        return (level + 1) / 2;
    }

    public static String getSpawnString(boolean[] willSpawn) {
        Object result = "";
        for (int i = 0; i < willSpawn.length; ++i) {
            result = (String)result + (willSpawn[i] ? "1" : "0");
        }
        return result;
    }

    public void loadSpawnsFromString(String s) {
        this.willSpawn = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            this.willSpawn[i] = s.substring(i, i + 1).compareTo("1") == 0;
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.loadSpawnsFromString(nbt.m_128461_("spawns"));
        this.size = nbt.m_128451_("size");
        this.xp = nbt.m_128451_("xp");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("spawns", CrystalSeedBlockEntity.getSpawnString(this.willSpawn));
        nbt.m_128405_("size", this.size);
        nbt.m_128405_("xp", this.xp);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("spawns", CrystalSeedBlockEntity.getSpawnString(this.willSpawn));
        nbt.m_128405_("size", this.size);
        nbt.m_128405_("xp", this.xp);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CrystalSeedBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        blockEntity.handleSound();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrystalSeedBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        if (blockEntity.size > 1000) {
            blockEntity.size = 0;
            ItemStack[] stacks = blockEntity.getNuggetDrops(blockEntity.willSpawn.length);
            double oneAng = 360.0 / (double)blockEntity.willSpawn.length;
            for (int i = 0; i < blockEntity.willSpawn.length; ++i) {
                if (!blockEntity.willSpawn[i]) continue;
                ItemStack nuggetStack = stacks[i];
                float offX = 0.4f * (float)Math.sin(Math.toRadians((double)i * oneAng));
                float offZ = 0.4f * (float)Math.cos(Math.toRadians((double)i * oneAng));
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5 + (double)offX, (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_() + 0.5 + (double)offZ, nuggetStack));
                level.m_6263_(null, (double)pos.m_123341_() + 0.5 + (double)offX, (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_() + 0.5 + (double)offZ, (SoundEvent)EmbersSounds.METAL_SEED_PING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.willSpawn = CrystalSeedBlockEntity.getSpawns(blockEntity.xp);
            blockEntity.m_6596_();
        }
    }

    protected ItemStack[] getNuggetDrops(int n) {
        return (ItemStack[])IntStream.range(0, n).mapToObj(i -> new ItemStack((ItemLike)Misc.getTaggedItem(this.tag))).toArray(ItemStack[]::new);
    }

    public void addExperience(int xp) {
        this.xp += xp;
    }

    public int getRequiredExperienceForLevel(int level) {
        return level * (level + 1) / 2 * 1000;
    }

    public static int getLevel(int xp) {
        return (int)Math.floor((Math.sqrt(5.0) * Math.sqrt(xp + 125) - 25.0) / 50.0);
    }

    @Override
    public void inject(BlockEntity injector, double ember) {
        this.size = (int)((double)this.size + ember);
        this.addExperience((int)ember);
        this.m_6596_();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.METAL_SEED_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1;
    }

    @Override
    public void addOtherDescription(List<Component> strings, Direction facing) {
        int level = CrystalSeedBlockEntity.getLevel(this.xp);
        int requiredCurrentXP = this.getRequiredExperienceForLevel(level);
        int requiredNextXP = this.getRequiredExperienceForLevel(level + 1);
        strings.add((Component)Component.m_237110_((String)"embers.tooltip.crystal.level", (Object[])new Object[]{level}));
        strings.add((Component)Component.m_237110_((String)"embers.tooltip.crystal.xp", (Object[])new Object[]{this.xp - requiredCurrentXP, requiredNextXP - requiredCurrentXP}));
    }
}

