/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.MechEdgeBlockBase;
import com.rekindled.embers.blockentity.ReservoirBlockEntity;
import com.rekindled.embers.datagen.EmbersBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaminiteValveBlockEntity
extends BlockEntity {
    int ticksExisted = 0;
    ReservoirBlockEntity reservoir;
    IFluidHandler fluidHandler;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.fluidHandler);

    public CaminiteValveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.CAMINITE_VALVE_ENTITY.get(), pPos, pBlockState);
        this.fluidHandler = new IFluidHandler(){

            public int getTanks() {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).getTanks();
                }
                return 0;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).getFluidInTank(tank);
                }
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).getTankCapacity(tank);
                }
                return 0;
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).isFluidValid(tank, stack);
                }
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).fill(resource, action);
                }
                return 0;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).drain(resource, action);
                }
                return FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (CaminiteValveBlockEntity.this.reservoir != null) {
                    return ((IFluidHandler)CaminiteValveBlockEntity.this.reservoir.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)).drain(maxDrain, action);
                }
                return FluidStack.EMPTY;
            }
        };
    }

    public ReservoirBlockEntity getReservoir() {
        return this.reservoir;
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!(this.f_58859_ || capability != ForgeCapabilities.FLUID_HANDLER || facing != null && facing.m_122434_() == Direction.Axis.Y)) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void updateTank() {
        if (this.m_58901_() || !this.f_58857_.m_8055_(this.f_58858_).m_61138_(MechEdgeBlockBase.EDGE)) {
            return;
        }
        this.reservoir = null;
        BlockPos basePos = this.f_58858_.m_121955_(((MechEdgeBlockBase.MechEdge)((Object)this.f_58857_.m_8055_((BlockPos)this.f_58858_).m_61143_(MechEdgeBlockBase.EDGE))).centerPos);
        for (int i = 1; i < 64; ++i) {
            BlockPos pos = basePos.m_6625_(i);
            if (this.f_58857_.m_8055_(pos).m_204336_(EmbersBlockTags.RESERVOIR_EXPANSION)) continue;
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (!(tile instanceof ReservoirBlockEntity)) break;
            this.reservoir = (ReservoirBlockEntity)tile;
            break;
        }
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, CaminiteValveBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        if (blockEntity.reservoir != null && blockEntity.reservoir.m_58901_()) {
            blockEntity.reservoir = null;
        }
        if (blockEntity.ticksExisted % 20 == 0) {
            blockEntity.updateTank();
        }
    }
}

