/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.power.IEmberPacketProducer;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.api.tile.ISparkable;
import com.rekindled.embers.blockentity.EmberEmitterBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BeamSplitterBlockEntity
extends BlockEntity
implements IEmberPacketProducer,
IEmberPacketReceiver,
ISparkable {
    public BlockPos target1 = null;
    public BlockPos target2 = null;
    public Random random = new Random();
    public boolean polled = false;

    public BeamSplitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.BEAM_SPLITTER_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("target1X")) {
            this.target1 = new BlockPos(nbt.m_128451_("target1X"), nbt.m_128451_("target1Y"), nbt.m_128451_("target1Z"));
        }
        if (nbt.m_128441_("target2X")) {
            this.target2 = new BlockPos(nbt.m_128451_("target2X"), nbt.m_128451_("target2Y"), nbt.m_128451_("target2Z"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.target1 != null) {
            nbt.m_128405_("target1X", this.target1.m_123341_());
            nbt.m_128405_("target1Y", this.target1.m_123342_());
            nbt.m_128405_("target1Z", this.target1.m_123343_());
        }
        if (this.target2 != null) {
            nbt.m_128405_("target2X", this.target2.m_123341_());
            nbt.m_128405_("target2Y", this.target2.m_123342_());
            nbt.m_128405_("target2Z", this.target2.m_123343_());
        }
    }

    @Override
    public boolean hasRoomFor(double ember) {
        if (this.polled) {
            return false;
        }
        this.polled = true;
        if (this.hasRoomTarget(this.target1, ember / 2.0) && this.hasRoomTarget(this.target2, ember / 2.0)) {
            this.polled = false;
            return true;
        }
        if (this.hasRoomTarget(this.target1, ember)) {
            this.polled = false;
            return true;
        }
        if (this.hasRoomTarget(this.target2, ember)) {
            this.polled = false;
            return true;
        }
        this.polled = false;
        return false;
    }

    public boolean hasRoomTarget(BlockPos target, double ember) {
        BlockEntity blockEntity;
        if (target != null && this.f_58857_.m_46749_(target) && (blockEntity = this.f_58857_.m_7702_(target)) instanceof IEmberPacketReceiver) {
            IEmberPacketReceiver targetBE = (IEmberPacketReceiver)blockEntity;
            return targetBE.hasRoomFor(ember);
        }
        return false;
    }

    @Override
    public void sparkProgress(BlockEntity tile, double ember) {
        this.split(ember);
    }

    @Override
    public boolean onReceive(EmberPacketEntity packet) {
        if (packet.pos != this.m_58899_()) {
            this.split(packet.value);
        }
        return true;
    }

    public void split(double ember) {
        if ((this.target1 != null || this.target2 != null) && ember > 0.1) {
            boolean room2;
            Direction.Axis axis = (Direction.Axis)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61365_);
            double value = ember / 2.0;
            boolean room1 = this.hasRoomTarget(this.target1, value) || this.target2 == null;
            boolean bl = room2 = this.hasRoomTarget(this.target2, value) || this.target1 == null;
            if (room1 != room2) {
                value = ember;
            }
            if (room1 || !room1 && !room2) {
                EmberPacketEntity packet1 = (EmberPacketEntity)((EntityType)RegistryManager.EMBER_PACKET.get()).m_20615_(this.f_58857_);
                Vec3 velocity1 = EmberEmitterBlockEntity.getBurstVelocity(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
                packet1.initCustom(this.f_58858_, this.target1, velocity1.f_82479_, velocity1.f_82480_, velocity1.f_82481_, value);
                this.f_58857_.m_7967_((Entity)packet1);
            }
            if (room2 || !room1 && !room2) {
                EmberPacketEntity packet2 = (EmberPacketEntity)((EntityType)RegistryManager.EMBER_PACKET.get()).m_20615_(this.f_58857_);
                Vec3 velocity2 = EmberEmitterBlockEntity.getBurstVelocity(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis));
                packet2.initCustom(this.f_58858_, this.target2, velocity2.f_82479_, velocity2.f_82480_, velocity2.f_82481_, value);
                this.f_58857_.m_7967_((Entity)packet2);
            }
            this.f_58857_.m_5594_(null, this.f_58858_, ember >= 100.0 ? (SoundEvent)EmbersSounds.EMBER_EMIT_BIG.get() : (SoundEvent)EmbersSounds.EMBER_EMIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void setTargetPosition(BlockPos pos, Direction side) {
        if (pos != this.f_58858_ && side.m_122434_() == this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61365_)) {
            if (side.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.target1 = pos;
            } else {
                this.target2 = pos;
            }
            this.m_6596_();
        }
    }

    @Override
    public Direction getEmittingDirection(Direction side) {
        if (side.m_122434_() == this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61365_)) {
            return side;
        }
        return null;
    }
}

