/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.DoubleTallMachineBlock;
import com.rekindled.embers.block.MechEdgeBlockBase;
import com.rekindled.embers.blockentity.InfernoForgeBottomBlockEntity;
import com.rekindled.embers.blockentity.InfernoForgeTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.util.Misc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class InfernoForgeBlock
extends DoubleTallMachineBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape BOTTOM_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), Block.m_49796_((double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0)});
    public static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public InfernoForgeBlock(BlockBehaviour.Properties pProperties, SoundType topSound) {
        super(pProperties, topSound);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            return BOTTOM_AABB;
        }
        return TOP_AABB;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!player.m_36341_() && (blockEntity = level.m_7702_(pos)) instanceof InfernoForgeTopBlockEntity) {
            InfernoForgeTopBlockEntity hatch = (InfernoForgeTopBlockEntity)blockEntity;
            blockEntity = level.m_7702_(pos.m_7495_());
            if (blockEntity instanceof InfernoForgeBottomBlockEntity) {
                InfernoForgeBottomBlockEntity forge = (InfernoForgeBottomBlockEntity)blockEntity;
                if (forge.progress == 0) {
                    if (hatch.open && forge.capability.getEmber() <= 0.0) {
                        if (level.m_5776_()) {
                            player.m_213846_((Component)Component.m_237115_((String)"embers.tooltip.forge.cannot_start"));
                        }
                        return InteractionResult.CONSUME;
                    }
                    if (!level.m_5776_()) {
                        hatch.open = !hatch.open;
                        hatch.lastToggle = level.m_46467_();
                        if (hatch.open) {
                            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.INFERNO_FORGE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.INFERNO_FORGE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        hatch.m_6596_();
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof InfernoForgeTopBlockEntity) {
                InfernoForgeTopBlockEntity hatch = (InfernoForgeTopBlockEntity)blockEntity;
                if (hatch.open) {
                    return Shapes.m_83040_();
                }
            }
            return TOP_AABB;
        }
        return super.m_5939_(state, level, pos, context);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            IItemHandler handler;
            for (MechEdgeBlockBase.MechEdge edge : MechEdgeBlockBase.MechEdge.values()) {
                BlockPos cornerPos = pos.m_121996_(edge.centerPos);
                if (!(level.m_8055_(cornerPos).m_60734_() instanceof MechEdgeBlockBase)) continue;
                level.m_46961_(cornerPos, false);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null && (handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null)) != null) {
                Misc.spawnInventoryInWorld(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, handler);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        if (state == null) {
            return null;
        }
        boolean lower = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER;
        for (MechEdgeBlockBase.MechEdge edge : MechEdgeBlockBase.MechEdge.values()) {
            if (!pContext.m_43725_().m_8055_(pContext.m_8083_().m_121996_(edge.centerPos)).m_60629_(pContext)) {
                return null;
            }
            if (!lower || pContext.m_43725_().m_8055_(pContext.m_8083_().m_121996_(edge.centerPos.m_7495_())).m_60629_(pContext)) continue;
            return null;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)pContext.m_8125_().m_122434_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
        for (MechEdgeBlockBase.MechEdge edge : MechEdgeBlockBase.MechEdge.values()) {
            BlockState edgeState = (BlockState)((Block)RegistryManager.INFERNO_FORGE_EDGE.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(pos.m_121996_(edge.centerPos)).m_76152_() == Fluids.f_76193_));
            level.m_7731_(pos.m_121996_(edge.centerPos), (BlockState)((BlockState)edgeState.m_61124_(MechEdgeBlockBase.EDGE, (Comparable)((Object)edge))).m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)half), 3);
        }
        if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            BlockState topState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_));
            level.m_7731_(pos.m_7494_(), (BlockState)topState.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (pState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            return ((BlockEntityType)RegistryManager.INFERNO_FORGE_BOTTOM_ENTITY.get()).m_155264_(pPos, pState);
        }
        return ((BlockEntityType)RegistryManager.INFERNO_FORGE_TOP_ENTITY.get()).m_155264_(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            return pLevel.f_46443_ ? InfernoForgeBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.INFERNO_FORGE_BOTTOM_ENTITY.get()), InfernoForgeBottomBlockEntity::clientTick) : InfernoForgeBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.INFERNO_FORGE_BOTTOM_ENTITY.get()), InfernoForgeBottomBlockEntity::serverTick);
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61364_});
    }
}

