/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.DialBaseBlock;
import com.rekindled.embers.blockentity.ClockworkAttenuatorBlockEntity;
import com.rekindled.embers.util.DecimalFormats;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ClockworkAttenuatorBlock
extends DialBaseBlock
implements EntityBlock {
    public static final String DIAL_TYPE = "work";

    public ClockworkAttenuatorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public List<Component> getDisplayInfo(Level world, BlockPos pos, BlockState state, int maxLines) {
        List<Component> text = super.getDisplayInfo(world, pos, state, maxLines);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ClockworkAttenuatorBlockEntity) {
            DecimalFormat multiplierFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.attenuator_multiplier");
            double activeSpeed = ((ClockworkAttenuatorBlockEntity)tile).activeSpeed;
            double inactiveSpeed = ((ClockworkAttenuatorBlockEntity)tile).inactiveSpeed;
            boolean active = world.m_276867_(pos);
            text.add((Component)Component.m_237110_((String)"embers.tooltip.attenuator.on", (Object[])new Object[]{multiplierFormat.format(activeSpeed)}).m_130940_(active ? ChatFormatting.GREEN : ChatFormatting.DARK_GREEN));
            text.add((Component)Component.m_237110_((String)"embers.tooltip.attenuator.off", (Object[])new Object[]{multiplierFormat.format(inactiveSpeed)}).m_130940_(!active ? ChatFormatting.RED : ChatFormatting.DARK_RED));
        }
        return text;
    }

    @Override
    protected void getBEData(Direction facing, ArrayList<Component> text, BlockEntity blockEntity, int maxLines) {
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ClockworkAttenuatorBlockEntity) {
            ClockworkAttenuatorBlockEntity attenuatorEntity = (ClockworkAttenuatorBlockEntity)blockEntity;
            if (level.m_276867_(pos)) {
                attenuatorEntity.activeSpeed = player.m_36341_() ? attenuatorEntity.getPrevious(attenuatorEntity.activeSpeed) : attenuatorEntity.getNext(attenuatorEntity.activeSpeed);
            } else {
                attenuatorEntity.inactiveSpeed = player.m_36341_() ? attenuatorEntity.getPrevious(attenuatorEntity.inactiveSpeed) : attenuatorEntity.getNext(attenuatorEntity.inactiveSpeed);
            }
            attenuatorEntity.m_6596_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.CLOCKWORK_ATTENUATOR_ENTITY.get()).m_155264_(pPos, pState);
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }
}

