/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.damage.DamageEmber;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.util.EmberInventoryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FlameBarrierAugment
extends AugmentBase {
    public FlameBarrierAugment(ResourceLocation id) {
        super(id, 2.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource().m_7639_() instanceof LivingEntity) {
                int barrierLevel = AugmentUtil.getArmorAugmentLevel((LivingEntity)player, this);
                float strength = (float)(2.0 * (Math.atan(0.6 * (double)barrierLevel) / Math.PI));
                if (barrierLevel > 0 && EmberInventoryUtil.getEmberTotal(player) >= this.cost) {
                    EmberInventoryUtil.removeEmber(player, this.cost);
                    DamageEmber damage = new DamageEmber((Holder<DamageType>)((Registry)player.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(EmbersDamageTypes.EMBER_KEY), (Entity)player);
                    event.getSource().m_7639_().m_6469_((DamageSource)damage, strength * event.getAmount() * 0.5f);
                    event.getSource().m_7639_().m_20254_(barrierLevel + 1);
                    event.getEntity().m_9236_().m_6269_(null, (Entity)event.getEntity(), (SoundEvent)EmbersSounds.FIREBALL_HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    Level level = event.getEntity().m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)GlowParticleOptions.EMBER, event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() / 2.0, event.getEntity().m_20189_(), 20, 0.5, 0.5, 0.5, 0.3);
                    }
                }
            }
        }
    }
}

