/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.api.tile;

import com.rekindled.embers.api.filter.IFilter;
import com.rekindled.embers.api.tile.IOrderSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class OrderStack {
    private BlockPos pos;
    private IFilter filter;
    private int size;

    public OrderStack(BlockPos pos, IFilter filter, int size) {
        this.pos = pos;
        this.filter = filter;
        this.size = size;
    }

    public OrderStack(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IOrderSource getSource(Level world) {
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IOrderSource) {
            return (IOrderSource)tile;
        }
        return null;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public int getSize() {
        return this.size;
    }

    public boolean acceptsItem(Level world, ItemStack stack) {
        IItemHandler itemHandler;
        IOrderSource source = this.getSource(world);
        if (source != null && (itemHandler = source.getItemHandler()) != null) {
            return this.filter.acceptsItem(stack, itemHandler);
        }
        return false;
    }

    public void deplete(int n) {
        this.size -= n;
    }

    public void increment(int n) {
        this.size += n;
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128405_("x", this.pos.m_123341_());
        tag.m_128405_("y", this.pos.m_123342_());
        tag.m_128405_("z", this.pos.m_123343_());
        tag.m_128365_("filter", (Tag)this.filter.writeToNBT(new CompoundTag()));
        tag.m_128405_("size", this.size);
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        this.pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
        this.size = tag.m_128451_("size");
    }

    public void reset(IFilter filter, int size) {
        this.filter = filter;
        this.size = size;
    }
}

