/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.api.projectile;

import com.rekindled.embers.api.projectile.IProjectileEffect;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EffectArea
implements IProjectileEffect {
    IProjectileEffect effect;
    double radius;
    boolean activateOnFizzle;

    public EffectArea(IProjectileEffect effect, double radius, boolean activateOnFizzle) {
        this.effect = effect;
        this.radius = radius;
        this.activateOnFizzle = activateOnFizzle;
    }

    public IProjectileEffect getEffect() {
        return this.effect;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean doesActivateOnFizzle() {
        return this.activateOnFizzle;
    }

    public void setActivateOnFizzle(boolean activateOnFizzle) {
        this.activateOnFizzle = activateOnFizzle;
    }

    @Override
    public void onHit(Level world, HitResult raytrace, IProjectilePreset projectile) {
        Vec3 pos = raytrace.m_82450_();
        this.doAreaEffect(world, projectile, pos);
    }

    @Override
    public void onFizzle(Level world, Vec3 pos, @Nullable IProjectilePreset projectile) {
        if (this.activateOnFizzle) {
            this.doAreaEffect(world, projectile, pos);
        }
    }

    private void doAreaEffect(Level world, IProjectilePreset projectile, Vec3 pos) {
        AABB aabb = new AABB(pos.f_82479_ - this.radius, pos.f_82480_ - this.radius, pos.f_82481_ - this.radius, pos.f_82479_ + this.radius, pos.f_82480_ + this.radius, pos.f_82481_ + this.radius);
        List entities = world.m_6249_(projectile.getShooter(), aabb, entity -> true);
        for (Entity entity2 : entities) {
            this.effect.onHit(world, (HitResult)new EntityHitResult(entity2), projectile);
        }
    }
}

